package com.ellabook.push;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ellabook.entity.user.MessageAdvice;
import com.ellabook.push.android.AndroidFilecast;
import com.ellabook.push.android.AndroidUnicast;
import com.ellabook.push.ios.IOSFilecast;
import com.ellabook.push.ios.IOSUnicast;
import com.ellabook.util.SendAdviceConfig;
import org.apache.commons.lang.time.DateFormatUtils;


public class MessagePush {
    private final static String iosAppKey = MessagePushUtil.IOS_APPKEY.getType();
    private final static String androidAppKey = MessagePushUtil.ANDROID_APPKEY.getType();
    private final static String androidAppMasterSecret = MessagePushUtil.ANDROID_APPMASTERSECRET.getType();
    private final static String iosAppMasterSecret = MessagePushUtil.IOS_APPMASTERSECRET.getType();
    private final static PushClient client = new PushClient();
    private final static String miActivity = "com.ellabook.umeng.UmengNotifyClickActivity";
    private final static String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public boolean sendAndroidUnicast(String deviceToken, JSONObject json) throws Exception {
        AndroidUnicast unicast = new AndroidUnicast(androidAppKey, androidAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setTicker("Android unicast ticker");
        unicast.setTitle(json.getString("alert"));
        unicast.setText(json.getString("alert"));
        unicast.goAppAfterOpen();
        unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);

        unicast.setCustomField(json.toString());
        // TODO Set 'production_mode' to 'false' if it's a test device.
        // For how to register a test device, please see the developer doc.
//        unicast.setProductionMode();
        unicast.setTestMode();

        // Set customized fields
        unicast.setExtraField("test", "helloworld");
        return client.send(unicast);
    }

    public boolean sendIOSUnicast(String deviceToken, JSONObject json) throws Exception {
        IOSUnicast unicast = new IOSUnicast(iosAppKey, iosAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setAlert(json.getString("alert"));
        unicast.setBadge(0);
        unicast.setContentAvailable(1);
        unicast.setSound("default");
        // TODO set 'production_mode' to 'true' if your app is under production mode
//        unicast.setProductionMode();
        unicast.setTestMode();
        // Set customized fields

        unicast.setCustomizedField("custom", json.toString());
        return client.send(unicast);
    }


    public static boolean sendIOSFilecast(String iosDeviceToken, MessageAdvice messageAdvice) throws Exception {
        IOSFilecast filecast = new IOSFilecast(iosAppKey, iosAppMasterSecret);
        if (messageAdvice.getStartTime() != null) {
            filecast.setStartTime(DateFormatUtils.format(messageAdvice.getStartTime(), TIME_PATTERN));
        }
        String fileId = client.uploadContents(iosAppKey, iosAppMasterSecret, iosDeviceToken);
        JSONObject json = new JSONObject();
        json.put("title", messageAdvice.getTitle());
        json.put("subtitle", messageAdvice.getSubTitle());
        json.put("body", messageAdvice.getContent());
        filecast.setFileId(fileId);
        filecast.setAlert(json);
        filecast.setSound("default");
        String a = SendAdviceConfig.getEnvironment();
        if ("sandbox".equals(SendAdviceConfig.getEnvironment())) {
            filecast.setTestMode();
        } else {
            filecast.setProductionMode();
        }
        filecast.setProductionMode();
        String returnJson = JSONObject.toJSONString(messageAdvice, SerializerFeature.WriteNullStringAsEmpty);
        filecast.setCustomizedField("custom", returnJson);
        return client.send(filecast);
    }

    public static boolean sendAndroidFilecast(String androidDeviceToken, MessageAdvice messageAdvice) throws Exception {
        AndroidFilecast filecast = new AndroidFilecast(androidAppKey, androidAppMasterSecret);
        if (messageAdvice.getStartTime() != null) {
            filecast.setStartTime(DateFormatUtils.format(messageAdvice.getStartTime(), TIME_PATTERN));
        }
        String fileId = client.uploadContents(androidAppKey, androidAppMasterSecret, androidDeviceToken);
        filecast.setFileId(fileId);
        filecast.setTicker(messageAdvice.getTitle());
        filecast.setTitle(messageAdvice.getSubTitle());
        filecast.setText(messageAdvice.getContent());
        filecast.goAppAfterOpen();
        if ("sandbox".equals(SendAdviceConfig.getEnvironment())) {
            filecast.setTestMode();
        } else {
            filecast.setProductionMode();
        }
        filecast.setMipush(true);
        filecast.setMiActivity(miActivity);
        filecast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        String returnJson = JSONObject.toJSONString(messageAdvice, SerializerFeature.WriteNullStringAsEmpty);
        filecast.setCustomField(returnJson);
        return client.send(filecast);
    }

}
