package com.ellabook.point;

import java.math.BigDecimal;

import com.ellabook.entity.user.usertask.PointsAccount;

/**
 * 积分操作接口
 *
 * @author maofengHan
 */
public interface PointOperation {

    /**
     * 积分变更操作
     * <p>
     * 根据发生数量改变用户积分，并生成积分变更记录
     * </p>
     *
     * @param operateType 操作类型
     * @param uid         用户ID
     * @param amount      发生数量
     * @param referenceId 关联ID
     * @return 变更记录
     */
    PointsAccount operate(PointOperationEnum operateType, String uid, BigDecimal amount, String taskCode,
                          String referenceId);
}
