package com.ellabook.mq.message;

import com.ellabook.entity.book.vo.UploadBookVO;
import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

import java.util.List;

/**
 * @author D-L
 * @version 1.0.0
 * @ClassName SynNewBookMsg.java
 * @Description 同步新书到海外库 消息体
 * @createTime 2021-07-08 17:40:00
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SynNewBookMsg extends BaseMsg {

    //消息Id
    private String id;

    //账户uid
    private String uid;

    List<UploadBookVO> uploadBookVOList;

    @Override
    public String getTag() {
        return MsgTagEnum.SYN_NEW_BOOK_MAKING.getTag();
    }
}
