package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 分享图书
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShareBookMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 图书编码
     */
    private String bookCode;


    private long bookId;

    @Override
    public String getTag() {
        return MsgTagEnum.SHARE_BOOK.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
