package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

import java.math.BigDecimal;

/**
 * 充值咿啦币消息
 *
 * @author maofengHan
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RechargeEllaCoinMsg extends BaseMsg {

    /**
     * 消息ID，支付成功订单编号
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 实际支付金额
     */
    private BigDecimal amount;

    /**
     * 平台（ANDROID，IOS）
     */
    private String resource;

    @Override
    public String getTag() {
        return MsgTagEnum.RECHARGE_ELLA_COIN.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
