package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 浏览绘本
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReadPictureKookMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 绘本编码
     */
    private String pictureBookCode;


    @Override
    public String getTag() {
        return MsgTagEnum.READ_PICTURE_BOOK.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
