package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 单次阅读时长
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReadBookTimeMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 用户孩子ID
     */
    private String cid;

    /**
     * 图书编码
     */
    private String bookCode;

    private int readTime;
    /**
     * 客户端版本号
     */
    private String clientVersion;

    @Override
    public String getTag() {
        return MsgTagEnum.READ_BOOK_TIME.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getCid() {
        return this.cid;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }
}
