package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 开通（续费）会员消息
 *
 * @author maofengHan
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OpenVipMsg extends BaseMsg {

    /**
     * 消息ID，支付成功订单编号
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 会员卡类型 CARD_YEAR:年卡 CARD_MONTH:月卡
     */
    private String type;

    /**
     * 平台（ANDROID，IOS）
     */
    private String resource;

    /**
     * 支付方式：ALIPAY-支付宝,  APPLE_IAP-苹果,  ELLA_COIN-咿啦币,  HUAWEIPAY-华为,   WXPAY-微信,  CORPORATE-对公支付,ELLA_POINTS-积分
     */
    private String paymentPlatform = "ELLA_COIN";

    @Override
    public String getTag() {
        return MsgTagEnum.OPEN_VIP.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
