package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

import java.math.BigDecimal;

/**
 * 累计在线时间消息
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OnlineTimeMsg extends BaseMsg {

    private String id;

    /**
     * 用户ID
     */
    private String uid;

    private int onlineTime;
    /**
     * 平台（ANDROID，IOS）
     */
    private String resource;

    @Override
    public String getTag() {
        return MsgTagEnum.ONLINE_TIME.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
