package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 邀请注册
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InviteRegisterMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 邀请发起者的uid
     */
    private String uid;

    /**
     * 被邀请人uid(注册人的uid)
     */
    private String invitedUid;


    @Override
    public String getTag() {
        return MsgTagEnum.INVITE_REGISTER.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
