package com.ellabook.mq.message;

import java.math.BigDecimal;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;

import lombok.*;

/**
 * 单本图书购买成功消息
 *
 * @author maofengHan
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BuyBookMsg extends BaseMsg {

    /**
     * 消息ID，支付成功订单编号
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 图书编码
     */
    private String bookCode;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 实际支付金额
     */
    private BigDecimal amount;

    /**
     * 红包金额
     */
    private BigDecimal couponAmount;

    /**
     * 支付的积分数量
     */
    private BigDecimal pointAmount;

    private boolean isTrigger;

    /**
     * 平台（ANDROID，IOS）
     */
    private String resource;

    @Override
    public String getTag() {
        return MsgTagEnum.BUY_BOOK.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
