package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BbkModifyOrderMsg extends BaseMsg {
    private String id; //BBK账号
    private String uid;
    private String orderNo;
    private String tradeNo;//第三方交易流水号

    @Override
    public String getTag() {
        return MsgTagEnum.BBK_MODIFY_ORDER.getTag();
    }


    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
