package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BbkCreateOrderMsg extends BaseMsg {
    private String id; //BBK账号
    private String uid;
    private String orderNo;
    private String customerId; //BBK账号
    private String machineId;//BBK机器号
    private String openId;//
    private String payAmount;//支付金额
    private String orderTitle;//订单标题
    private String orderDesc;//订单描述
    private String orderInfo;//订单详情地址
    private boolean sendToParent;//家长代付
    private String categoryAttribute;
    private String proxyPayUrl;
    private String commodityImage;  //商品图片

    @Override
    public String getTag() {
        return MsgTagEnum.BBK_CREATE_ORDER.getTag();
    }


    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
