package com.ellabook.enums;

/**
 * ID/Code生成前缀及随机位数配置枚举
 *
 * @author maofengHan
 */
public enum IdEnum {
    UID() {
        @Override
        public String getPrefix() {
            return "U";
        }

        @Override
        public int getRandomNum() {
            return 4;
        }

        @Override
        public String getDescription() {
            return "用户UID";
        }
    },
    POINTS_CODE() {
        @Override
        public String getPrefix() {
            return "PC";
        }

        @Override
        public int getRandomNum() {
            return 6;
        }

        @Override
        public String getDescription() {
            return "积分流水记录ID";
        }
    },
    USER_TASK_RECORD_ID() {
        @Override
        public String getPrefix() {
            return "UTR";
        }

        @Override
        public int getRandomNum() {
            return 6;
        }

        @Override
        public String getDescription() {
            return "用户任务记录ID";
        }
    },
    FK_CARD_FLOW_ID() {
        @Override
        public String getPrefix() {
            return "FCF";
        }

        @Override
        public int getRandomNum() {
            return 6;
        }

        @Override
        public String getDescription() {
            return "用户福卡记录流水ID";
        }
    },//
    /* v2.4.5 */
    EXP_FINISHED_RECORD() {
        @Override
        public String getPrefix() {
            return "EFR";
        }

        @Override
        public int getRandomNum() {
            return 6;
        }

        @Override
        public String getDescription() {
            return "用户经验完成记录ID";
        }
    },//
    /* v2.4.7 */
    BOOK_SUBJECT_COMMENT() {
        @Override
        public String getPrefix() {
            return "BSC";
        }

        @Override
        public int getRandomNum() {
            return 4;
        }

        @Override
        public String getDescription() {
            return "图书专题评论ID";
        }
    };

    /**
     * 前缀
     *
     * @return
     */
    public abstract String getPrefix();

    /**
     * 后缀随机位数
     *
     * @return
     */
    public abstract int getRandomNum();

    /**
     * 描述
     *
     * @return
     */
    public abstract String getDescription();
}
