package com.ellabook.entity.user.vo;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.dto.BaseTaskDTO;
import com.ellabook.entity.user.usertask.TaskParam;
import com.ellabook.entity.user.usertask.TaskReward;
import com.ellabook.entity.user.usertask.UserTaskRecord;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
//@JsonInclude(JsonInclude.Include.NON_NULL)
public class UserTaskRecordVO extends UserTaskRecord {
//    /**
//     * 操作状态
//     */
//    @Getter
//    private String opStatus;

    @Getter
    private List<TaskReward> rewardList = new ArrayList<>();

    /**
     * 任务图标
     */
    @Getter
    private String taskImageUrl;
    /**
     * 任务名称
     */
    @Getter
    private String taskName;
    /**
     * 任务描述
     */
    @Getter
    private String taskDesc;
    /**
     * 任务类型
     */
    @Getter
    private String taskType;

    /**
     * 行为名
     */
    @Getter
    private String actionName;
    /**
     * 行为类型
     */
    @Getter
    private String actionType;
    /**
     * 行为描述
     */
    @Getter
    private String actionDesc;

    /*************** task:reward=1:1 *******************/
//    /**
//     * 奖励类型
//     */
//    @Getter
//    private String rewardType;
//    /**
//     * 奖励内容
//     */
//    @Getter
//    private String rewardContent;
//    /**
//     * 奖励描述
//     */
//    @Getter
//    private String rewardDesc;

    /**
     * 任务限制参数
     */
    private String taskParam;
    /***************** task bar *******************/
//    @Getter
    private String taskWallName;

    public UserTaskRecordVO createUserTaskRecordVO(String recordId, String taskStatus, String rewardStatus) {
        TaskParam taskParamObj = StringUtils.isBlank(taskParam) ? new TaskParam() : JSONObject.parseObject(taskParam, TaskParam.class);

        return new UserTaskRecordVO(
                recordId, super.getUid(),
                super.getTaskCode(), super.getTaskWallCode(),
                taskStatus, rewardStatus,
                0, taskParamObj.getCount(), super.getCreateTime(), super.getUpdateTime());
    }

    public static UserTaskRecordVO createUserTaskRecordVO(String recordId, String taskStatus, String rewardStatus, BaseTaskDTO baseTaskDTO, List<TaskReward> rewardList) {
        String taskParam = baseTaskDTO.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank(taskParam) ? new TaskParam() : JSONObject.parseObject(taskParam, TaskParam.class);

        UserTaskRecordVO userTaskRecordVO = new UserTaskRecordVO(
                recordId, baseTaskDTO.getUid(),
                baseTaskDTO.getTaskCode(), baseTaskDTO.getTaskWallCode(),
                taskStatus, rewardStatus,
                0, taskParamObj.getCount(), baseTaskDTO.getCreateTime(), baseTaskDTO.getUpdateTime());

        userTaskRecordVO.setTaskImageUrl(baseTaskDTO.getTaskImageUrl());
        userTaskRecordVO.setTaskName(baseTaskDTO.getTaskName());
        userTaskRecordVO.setTaskDesc(baseTaskDTO.getTaskDesc());
        userTaskRecordVO.setTaskType(baseTaskDTO.getTaskType());
        userTaskRecordVO.setActionName(baseTaskDTO.getActionName());
        userTaskRecordVO.setActionType(baseTaskDTO.getActionType());
        userTaskRecordVO.setActionDesc(baseTaskDTO.getActionDesc());
        if (rewardList != null) {
            userTaskRecordVO.setRewardList(rewardList);
        }
        return userTaskRecordVO;
    }

    public void updateByTaskParam() {
        TaskParam taskParamObj = StringUtils.isBlank(taskParam) ? new TaskParam() : JSONObject.parseObject(taskParam, TaskParam.class);
        super.setCurrentNum(0);
        super.setMaxNum(taskParamObj.getCount());
    }


//    public TaskWallVO createTaskWallVO(String taskWallCode, List<UserTaskRecordVO> taskList){
//        return new TaskWallVO(taskWallCode, taskWallName, taskList);
//    }

    public UserTaskRecordVO(String recordId, String uid, String taskCode, String taskWallCode, String taskStatus, String rewardStatus, int currentNum, int maxNum, Date createTime, Date updateTime) {
        super.setRecordId(recordId);
        super.setUid(uid);
        super.setTaskCode(taskCode);
        super.setTaskStatus(taskStatus);
        super.setRewardStatus(rewardStatus);
        super.setTaskWallCode(taskWallCode);
        super.setCurrentNum(currentNum);
        super.setMaxNum(maxNum);
        super.setCreateTime(createTime);
        super.setUpdateTime(updateTime);
    }

    public double pointVal() {
//        if (StringUtils.equalsIgnoreCase("POINT", rewardType)) {
//            try {
//                return new BigDecimal(rewardContent).doubleValue();
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
        if (CollectionUtils.isNotEmpty(rewardList)) {
            Double totalPoint = rewardList.stream().filter(e -> StringUtils.equalsIgnoreCase("POINT", e.getRewardType())).collect(Collectors.summingDouble(e -> new BigDecimal(e.getRewardContent()).doubleValue()));
            return totalPoint;
        }

        return 0D;
    }

//    public void updateRewardStatus(int currentNum, int maxNum, Date now) {
//        super.setCurrentNum(currentNum);
//        super.setMaxNum(maxNum);
//        super.setUpdateTime(now);
//
//        super.setRewardStatus(currentNum < maxNum ? "NOT_REACH" : "WAITING_RECEIVE");
//    }

//    public String getOpStatus() {
//        if (StringUtils.equalsIgnoreCase("HAS_COMPLETED", super.getTaskStatus())) {
//            //任务：已完成
//            return "finished";
//        }
//        if (StringUtils.equalsIgnoreCase("WAITING_RECEIVE", super.getTaskStatus())) {
//            //任务：待领取
//            return "toStart";
//        }
//        if (StringUtils.equalsIgnoreCase("HAS_RECEIVE", super.getTaskStatus())) {
//            //任务：已领取/进行中
//            if (StringUtils.equalsIgnoreCase("NOT_REACH", super.getRewardStatus())) {
//                return "underway";//奖励：未达成领取条件
//            }
//            if (StringUtils.equalsIgnoreCase("WAITING_RECEIVE", super.getRewardStatus())) {
//                return "toFinish";//奖励：待领取
//            }
//        }
//        return "";
//    }
}
