package com.ellabook.entity.user.vo;

import com.ellabook.entity.PublicParam;
import com.ellabook.util.doc.annotations.FieldExplain;

import java.io.Serializable;
import java.util.Date;

public class RegisterVo implements Serializable {
    private static final long serialVersionUID = 1413529370258240067L;

    @FieldExplain(explain = "用户名（`当前为手机号`）")
    private String customerName;

    @FieldExplain(explain = "密码（`6～16为英文及数字`）")
    private String password;

    @FieldExplain(explain = "客户端版本号（如：2.0.2）")
    private String clientVersion;

    @FieldExplain(explain = "国家编码")
    private String countryCode;

    @FieldExplain(explain = "注册渠道编码")
    private String channelCode;

    @FieldExplain(explain = "设备码")
    private String deviceNo = "";

    @FieldExplain(explain = "设备token：友盟下发，用于推送消息")
    private String deviceToken;

    @FieldExplain(explain = "注册类型：mobile,email")
    private String registerType;

    private String registerProduct;// 注册产品
    //private String registerVersion;//注册渠道包：cpa1,cpa2

    @FieldExplain(explain = "设备类型（ios，android）APP登录必传")
    private String clientType;

    @FieldExplain(explain = "客户端型号：huawei，ipad，iphone5s等")
    private String resource;

    @FieldExplain(explain = "用户注册验证类型<br>`0`:不校验验证码<br>`1`:校验验证码")
    private String registerVerificationType;

    @FieldExplain(explain = "短信验证码,目前有4位和6为两种，登录注册相关使用4位的（如：584962/4648）")
    private String checkCode;

    @FieldExplain(explain = "ios客户端app推广标识")
    private String IDFA;

    @FieldExplain(explain = "用户注册状态<br>`0`:已销号<br>`1`:已注册<br>`2`:待激活")
    private String status;

    @FieldExplain(explain = "邀请人uid")
    private String inviteUid;

    @FieldExplain(explain = "邮箱")
    private String email;

    @FieldExplain(explain = "第三方平台类型：WEIXIN,QQ,SINA,HUAWEI")
    private String platformType;

    private String role;

    private String registrationWay;
    private boolean existsOtherOperation = true;

    /**
     * 注册孩子信息（简单）
     * @version 2.7.9
     */
    /**
     * 性别
     */
    private String childrenSex;

    /**
     * 生日
     */
    private Date birthday;
//    private ChildrenSimpleVo childrenSimpleVo;

    private PublicParam publicParam;

    public RegisterVo(String customerName, String password, String channelCode, String registerType, String registerVerificationType, String email) {
        this.customerName = customerName;
        this.password = password;
        this.channelCode = channelCode;
        this.registerType = registerType;
        this.registerVerificationType = registerVerificationType;
        this.email = email;
    }

    public RegisterVo(String customerName, String channelCode, String status, String registerType, String registerVerificationType) {
        this.customerName = customerName;
        this.channelCode = channelCode;
        this.status = status;
        this.registerType = registerType;
        this.registerVerificationType = registerVerificationType;
    }

    public boolean isExistsOtherOperation() {
        return existsOtherOperation;
    }

    public void setExistsOtherOperation(boolean existsOtherOperation) {
        this.existsOtherOperation = existsOtherOperation;
    }

    public String getChildrenSex() {
        return childrenSex;
    }

    public void setChildrenSex(String childrenSex) {
        this.childrenSex = childrenSex;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getIDFA() {
        return IDFA;
    }

    public void setIDFA(String IDFA) {
        this.IDFA = IDFA;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getRegisterType() {
        return registerType;
    }

    public void setRegisterType(String registerType) {
        this.registerType = registerType;
    }

    public String getRegisterProduct() {
        return registerProduct;
    }

    public void setRegisterProduct(String registerProduct) {
        this.registerProduct = registerProduct;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getRegisterVerificationType() {
        return registerVerificationType;
    }

    public void setRegisterVerificationType(String registerVerificationType) {
        this.registerVerificationType = registerVerificationType;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getStatus() {
        return !"2".equals(status) ? "1" : "2";
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getInviteUid() {
        return inviteUid;
    }

    public void setInviteUid(String inviteUid) {
        this.inviteUid = inviteUid;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public RegisterVo(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public PublicParam getPublicParam() {
        return publicParam;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setPublicParam(PublicParam publicParam) {
        this.publicParam = publicParam;
    }

    public String getRegistrationWay() {
        return registrationWay;
    }

    public void setRegistrationWay(String registrationWay) {
        this.registrationWay = registrationWay;
    }

    public RegisterVo() {
    }
}