package com.ellabook.entity.user.vo;

import com.ellabook.entity.PublicParam;
import com.ellabook.entity.user.EducatorDetail;
import com.ellabook.util.doc.annotations.FieldExplain;
import lombok.Data;

import java.io.Serializable;

@Data
public class RegisterForH5Vo extends EducatorDetail implements Serializable {
    private static final long serialVersionUID = 1413529370258240067L;

    @FieldExplain(explain = "用户名（`手机号或邮箱`）")
    private String customerName;

    @FieldExplain(explain = "密码（`6～16为英文及数字`）")
    private String password;

    @FieldExplain(explain = "注册用户类型 学者T 或 家长P")
    private String role;

    @FieldExplain(explain = "国家编码")
    private String countryCode;

    @FieldExplain(explain = "注册渠道编码")
    private String channelCode;

    @FieldExplain(explain = "邀请人code")
    private String inviteCode;

    @FieldExplain(explain = "注册类型：mobile,email")
    private String registerType;

    @FieldExplain(explain = "短信验证码,目前有4位和6为两种，登录注册相关使用4位的（如：584962/4648）")
    private String checkCode;

    @FieldExplain(explain = "邮箱")
    private String email;

    private PublicParam publicParam;
}