package com.ellabook.entity.user.vo;

import com.ellabook.entity.PublicParamVO;
import com.ellabook.util.doc.annotations.FieldExplain;

import java.io.Serializable;

public class LoginVo extends PublicParamVO implements Serializable {
    private static final long serialVersionUID = 1413529370258240067L;

    @FieldExplain(explain = "用户名（`当前为手机号`）")
    private String customerName;

    @FieldExplain(explain = "密码（`6～16为英文及数字`）")
    private String password;

    @FieldExplain(explain = "设备码")
    private String deviceNo = "";

    @FieldExplain(explain = "设备token：友盟下发，用于推送消息")
    private String deviceToken;

    @FieldExplain(explain = "设备类型（ios，android）APP登录必传")
    private String clientType;

    @FieldExplain(explain = "客户端型号：huawei，ipad，iphone5s等")
    private String resource;

    @FieldExplain(explain = "客户端版本号（如：2.0.2）")
    private String clientVersion;

    @FieldExplain(explain = "注册渠道编码")
    private String channelCode = "";

    @FieldExplain(explain = "国家编码")
    private String countryCode;

    @FieldExplain(explain = "用户注册验证类型<br>`0`:不校验验证码<br>`1`:校验验证码<br>`2`:快捷登录")
    private String loginVerificationType;

    @FieldExplain(explain = "短信验证码：目前有4位和6为两种，登录注册相关使用4位的<br>（如：584962/4648）")
    private String checkCode;

    @FieldExplain(explain = "ios客户端app推广标识")
    private String IDFA;

    @FieldExplain(explain = "邮箱账户")
    private String email;

    public String getIDFA() {
        return IDFA;
    }

    public void setIDFA(String IDFA) {
        this.IDFA = IDFA;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getLoginVerificationType() {
        return loginVerificationType;
    }

    public void setLoginVerificationType(String loginVerificationType) {
        this.loginVerificationType = loginVerificationType;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}