package com.ellabook.entity.user.vo;

import com.ellabook.entity.PublicParam;
import com.ellabook.util.doc.annotations.FieldExplain;

import java.io.Serializable;

public class BindAndLoginVo implements Serializable {
    private static final long serialVersionUID = 7119645718566777868L;
    @FieldExplain(explain = "用户名（`当前为手机号`）")
    private String customerName;
    @FieldExplain(explain = "密码（`6～16为英文及数字`）")
    private String password;
    @FieldExplain(explain = "客户端版本号（如：2.0.2）")
    private String clientVersion;

    @FieldExplain(explain = "注册渠道编码")
    private String channelCode;
    @FieldExplain(explain = "国家编码")
    private String countryCode;
    @FieldExplain(explain = "设备码")
    private String deviceNo;
    @FieldExplain(explain = "设备token：友盟下发，用于推送消息")
    private String deviceToken;
    @FieldExplain(explain = "设备类型（ios，android）APP登录必传")
    private String clientType;
    @FieldExplain(explain = "客户端型号：huawei，ipad，iphone5s等")
    private String resource;

    private String registerVersion;// 登录渠道包：cpa1,cpa2
    @FieldExplain(explain = "`0`:请求登录（如果是老账号直接登录，若是新账号则loginFrom改为1或2回调当前接口）<br> `1`:仅第三方账号登录<br>`2`:第三方账号登录并绑手机<br>`3`:第三方账号登陆后绑手机号(新手机号)")
    private String loginFrom;
    @FieldExplain(explain = "第三方的openID（旧版本传参时将openid字段名转换成了uid）")
    private String uid;
    @FieldExplain(explain = "第三方的openID")
    private String openid;
    @FieldExplain(explain = "第三方的unionID <br>（第三方为保证不同平台拉取授权openid不一致问题设置的唯一标识）")
    private String unionID;
    @FieldExplain(explain = "第三方用户名称")
    private String idname;
    @FieldExplain(explain = "第三方用户性别")
    private String gender;
    @FieldExplain(explain = "第三方用户头像")
    private String iconurl;
    @FieldExplain(explain = "第三方平台类型：WEIXIN,QQ,SINA,HUAWEI")
    private String platformType;
    @FieldExplain(explain = "国家")
    private String country;
    @FieldExplain(explain = "省份")
    private String province;
    @FieldExplain(explain = "城市")
    private String city;
    @FieldExplain(explain = "请求来源：APP，BUSINESS，H5")
    private String type;
    @FieldExplain(explain = "是否校验验证码：`0`:否 `1`:是")
    private String loginVerificationType;
    @FieldExplain(explain = "短信验证码：目前有4位和6为两种，登录注册相关使用4位的<br>（如：584962/4648）")
    private String checkCode;
    @FieldExplain(explain = "送书活动编码")
    private String sendBookActivityCode;
    @FieldExplain(explain = "绑定状态 1：绑定 0.不绑定")
    private String bindStatus;

    private PublicParam publicParam;

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getRegisterVersion() {
        return registerVersion;
    }

    public void setRegisterVersion(String registerVersion) {
        this.registerVersion = registerVersion;
    }

    public String getLoginFrom() {
        return loginFrom;
    }

    public void setLoginFrom(String loginFrom) {
        this.loginFrom = loginFrom;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUnionID() {
        return unionID;
    }

    public void setUnionID(String unionID) {
        this.unionID = unionID;
    }

    public String getIdname() {
        return idname;
    }

    public void setIdname(String idname) {
        this.idname = idname;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getIconurl() {
        return iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getLoginVerificationType() {
        return loginVerificationType;
    }

    public void setLoginVerificationType(String loginVerificationType) {
        this.loginVerificationType = loginVerificationType;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getSendBookActivityCode() {
        return sendBookActivityCode;
    }

    public void setSendBookActivityCode(String sendBookActivityCode) {
        this.sendBookActivityCode = sendBookActivityCode;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BindAndLoginVo() {
    }

    public String getBindStatus() {
        return bindStatus;
    }

    public void setBindStatus(String bindStatus) {
        this.bindStatus = bindStatus;
    }

    public PublicParam getPublicParam() {
        return publicParam;
    }

    public void setPublicParam(PublicParam publicParam) {
        this.publicParam = publicParam;
    }

    public BindAndLoginVo(String customerName, String password, String uid, String unionID, String idname, String gender, String iconurl, String platformType, String country, String province, String city, String loginFrom, String type) {
        this.customerName = customerName;
        this.password = password;
        this.uid = uid;
        this.unionID = unionID;
        this.idname = idname;
        this.gender = gender;
        this.iconurl = iconurl;
        this.platformType = platformType;
        this.country = country;
        this.province = province;
        this.city = city;
        this.loginFrom = loginFrom;
        this.type = type;
    }
}
