package com.ellabook.entity.user.vo;

import com.ellabook.entity.user.dto.BaseTaskDTO;
import com.ellabook.entity.user.usertask.TaskReward;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/11/7 16:49
 * @Modified By:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseTaskVO {

    private String taskCode;

    private String taskName;

    private String taskDesc;

    private String taskType;

    private String actionCode;

    private String taskParam;

    private Date startTime;

    private Date endTime;

    private String taskImageUrl;

    private String taskAcceptType;

    private String rewardsAcceptType;

    private Integer cycleTime;

    private Integer finishTimes;

    private String status;

    private Date createTime;

    private Date updateTime;

    private String showFlag;
    /////////

    private String taskWallCode;

    private String recordId;

    private String uid;

    private String taskStatus;

    private String rewardStatus;

    private int currentNum;

    private int maxNum;


    private List<TaskReward> rewardList = new ArrayList<>();
    /**
     * 行为名
     */

    private String actionName;
    /**
     * 行为类型
     */

    private String actionType;
    /**
     * 行为描述
     */

    private String actionDesc;

    private String targetPageType;//跳转类型 H5地址,APP内部
    private String targetPage;//跳转地址
    private String targetParam;//跳转参数

    public BaseTaskVO(BaseTaskDTO baseTaskDTO) {
        taskCode = baseTaskDTO.getTaskCode();
        taskName = baseTaskDTO.getTaskName();
        taskDesc = baseTaskDTO.getTaskDesc();
        taskType = baseTaskDTO.getTaskType();
        taskImageUrl = baseTaskDTO.getTaskImageUrl();
        taskParam = baseTaskDTO.getTaskParam();
        taskWallCode = baseTaskDTO.getTaskWallCode();
        recordId = baseTaskDTO.getRecordId();
        uid = baseTaskDTO.getUid();
        taskStatus = baseTaskDTO.getTaskStatus();
        rewardStatus = baseTaskDTO.getRewardStatus();
        currentNum = baseTaskDTO.getCurrentNum();
        maxNum = baseTaskDTO.getMaxNum();
        rewardList = baseTaskDTO.getRewardList();
        actionName = baseTaskDTO.getActionName();
        actionType = baseTaskDTO.getActionType();
        actionDesc = baseTaskDTO.getActionDesc();
        targetPageType = baseTaskDTO.getTargetPageType();
        targetPage = baseTaskDTO.getTargetPage();
        targetParam = baseTaskDTO.getTargetParam();
    }
}
