package com.ellabook.entity.user.dto;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.experience.BaseExperience;
import lombok.*;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;

@EqualsAndHashCode(callSuper = true)
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseExperienceDTO extends BaseExperience {

    private Date currentCycleStartTime;//null

    private Date currentCycleEndTime;//null

    //单次完成目标值
    private int countByParam = 1;

    //周期内完成次数(-1:无上限)
    private int maxFinishTimes;

    /**
     * 是否可用
     * <p>
     * 当前时间处于开始时间与结束时间之间，且配置状态为NORMAL
     * </p>
     *
     * @return
     */
    public boolean checkAvailableAndInit(Date now, long actionCycleTime) {
//        if (! DataStatus.NORMAL.getValue().equalsIgnoreCase(this.getStatus())){
//            return false;
//        }

//        过期时长(-1:永久,0:自定义)
        int expireDuration = Optional.ofNullable(super.getExpireDuration()).orElse(0);
        boolean neverExpire = -1 == expireDuration;
        if (neverExpire) {
            //永不过期
            setCurrentCycleStartTime(null);
            setCurrentCycleEndTime(null);
        } else {
            Date startTime = super.getStartTime();
            Date endTime = super.getEndTime();
            if (startTime == null || endTime == null) {
                return false;
            }

            boolean available = checkTime(startTime, now, true)
                    && checkTime(now, endTime, true);
            if (!available) {
                return false;
            }

//            循环周期，单位/秒(0:非循环)
//            Integer cycleTime = super.getCycleTime();//
            long cycleTime = actionCycleTime;
            boolean cycle = Objects.nonNull(cycleTime) && cycleTime > 0;
            if (cycle) {
                //循环
                long period = now.getTime() - startTime.getTime();
                long realCycleTime = cycleTime * 1000L;    // 配置中记录的是秒，转换为毫秒循环时间
                long overTimes = Math.floorDiv(period, realCycleTime);

                setCurrentCycleStartTime(new Date(startTime.getTime() + overTimes * realCycleTime));
                Date currentCycleEndTime = new Date(this.currentCycleStartTime.getTime() + realCycleTime);
                setCurrentCycleEndTime(currentCycleEndTime);
                setCurrentCycleEndTime(currentCycleEndTime.before(endTime) ? currentCycleEndTime : endTime);
            } else {
                //非循环
                setCurrentCycleStartTime(startTime);
                setCurrentCycleEndTime(endTime);
            }

        }

        init();
        return true;
    }

    private boolean checkTime(Date earlier, Date later, boolean canEqual) {
        return canEqual ? !earlier.after(later) : later.after(earlier);
    }

    private void init() {
        //countByParam
        JSONObject expParam = Optional.ofNullable(JSONObject.parseObject(getExpParam())).orElse(new JSONObject());
        setCountByParam(Optional.ofNullable(expParam.getInteger("count")).orElse(1));

        //默认1
        setMaxFinishTimes(Optional.ofNullable(getFinishTimes()).orElse(1));
    }

}