package com.ellabook.entity.user;

import java.util.Date;
import java.io.Serializable;
import java.util.List;

/**
 * 个人中心菜单-菜单栏目表(EbPersonalMenu)实体类
 *
 * @author makejava
 * @since 2020-06-16 17:07:24
 */
public class EbPersonalMenu implements Serializable {
    private static final long serialVersionUID = 240492485056077709L;

    private Integer id;
    /**
     * 菜单编码code  P+年月日+4位随机数
     */
    private String menuCode;

    private String menuName;
    /**
     * 菜单图标地址
     */
    private String iconUrl;
    /**
     * 跳转展示形式 IMG:图标 TEXT:文本 NONE:无
     */
    private String jumpShowType;
    /**
     * 跳转展示图标的url地址（当jump_show_type=IMG）时
     */
    private String jumpShowImgUrl;
    /**
     * 跳转类型 SYSTEM:app内部路由跳转 H5:外部网页地址跳转
     */
    private String jumpTargetType;
    /**
     * 跳转地址，内部路由地址或者外部网页链接
     */
    private String jumpTargetUrl;
    /**
     * 菜单类型：
     * ELLA_COIN:咿啦币充值
     * VIP:咿啦会员
     * LISTEN_CARD:听书卡
     * COUPON:红包
     * POINT:积分任务
     * EYE_PROTECTION_MODE:护眼设置
     * INVITING:邀请好友
     * GDBANK:咿啦看书联名卡
     * WELFARE:加入阅读书院
     * EXCHANG:兑换
     * FEEDBACK:问题反馈
     * ABOUT_US:关于我们
     */
    private String menuType;
    /**
     * 所在角色是否展示的角色描述，多个以逗号隔开
     * 全部：All
     * 游客：TOURIST
     * 普通用户：USER
     * 会员用户：VIP
     * 家长：PARENT
     * 教师：TEACHER
     * 园长：DIRECTOR
     */
    private String role;
    /**
     * 所在国家是否展示的国家编号，多个以逗号隔开
     */
    private String countryId;
    /**
     * 限制版本，不在本字段配置的版本展示
     */
    private String limitVersion;
    /**
     * 所属 菜单模块编码
     */
    private String modularCode;
    /**
     * 排序字段
     */
    private Integer idx;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 数据状态（NORMAL：正常 EXCEPTION：异常）
     */
    private String status;

    private String showStatus;

    private List<EbPersonalLanguage> personalLanguageList;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getJumpShowType() {
        return jumpShowType;
    }

    public void setJumpShowType(String jumpShowType) {
        this.jumpShowType = jumpShowType;
    }

    public String getJumpShowImgUrl() {
        return jumpShowImgUrl;
    }

    public void setJumpShowImgUrl(String jumpShowImgUrl) {
        this.jumpShowImgUrl = jumpShowImgUrl;
    }

    public String getJumpTargetType() {
        return jumpTargetType;
    }

    public void setJumpTargetType(String jumpTargetType) {
        this.jumpTargetType = jumpTargetType;
    }

    public String getJumpTargetUrl() {
        return jumpTargetUrl;
    }

    public void setJumpTargetUrl(String jumpTargetUrl) {
        this.jumpTargetUrl = jumpTargetUrl;
    }

    public String getMenuType() {
        return menuType;
    }

    public void setMenuType(String menuType) {
        this.menuType = menuType;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getLimitVersion() {
        return limitVersion;
    }

    public void setLimitVersion(String limitVersion) {
        this.limitVersion = limitVersion;
    }

    public String getModularCode() {
        return modularCode;
    }

    public void setModularCode(String modularCode) {
        this.modularCode = modularCode;
    }

    public Integer getIdx() {
        return idx;
    }

    public void setIdx(Integer idx) {
        this.idx = idx;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<EbPersonalLanguage> getPersonalLanguageList() {
        return personalLanguageList;
    }

    public void setPersonalLanguageList(List<EbPersonalLanguage> personalLanguageList) {
        this.personalLanguageList = personalLanguageList;
    }

    public String getMenuName() {
        return menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public String getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(String showStatus) {
        this.showStatus = showStatus;
    }
}