package com.ellabook.entity.order.vo;

import com.ellabook.entity.PublicParam;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author mengxiangchao@ellabook.cn
 * @date 2018/3/14
 */
public class BatchRentBookVO extends BuyBookOrderVO {
    /**
     * v2.0 新的传参为数组[]
     */
    private List<String> list;
    /**
     * v1.0 旧的传参{uid:"",bookCodeList:[]}
     */
    private List<String> bookCodeList;

    private PublicParam publicParam;

    public PublicParam getPublicParam() {
        return publicParam;
    }

    public void setPublicParam(PublicParam publicParam) {
        this.publicParam = publicParam;
        if (publicParam != null) {
            this.setUid(publicParam.getUid());
        }
    }

    public List<String> getList() {
        return list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }

    public BatchRentBookVO() {
    }

    public BatchRentBookVO(String uid, List<String> list) {
        super(uid);
        this.list = list;
    }

    public List<String> getBookCodeList() {
        return bookCodeList;
    }

    public void setBookCodeList(List<String> bookCodeList) {
        if (CollectionUtils.isNotEmpty(bookCodeList)) {
            this.list = bookCodeList;
            this.bookCodeList = bookCodeList;
        }
    }

}