package com.ellabook.entity.order.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author D-L
 * @program: ella-server
 * @description: 会员页面配置获取接受参数
 * @date 2020-11-30 11:42:15
 */

@Data
public class VipConfigListDTO implements Serializable {
    /**
     * 会员商品配置编码
     */
    private String cardCode;

    /**
     * 购买会员卡类型:
     * 年卡: YEAR_CARD
     * 月卡: MONTH_CARD
     * 周卡：WEKK_CARD
     * 连续包年：AUTO_YEAR_CARD
     * 连续包月：AUTO_MONTH_CARD
     */
    @JsonIgnore
    private String vipType;

    /**
     * 是否限制购买
     */
    @JsonIgnore
    private String limitBuyStatus;

    /**
     * 限制购买次数
     */
    @JsonIgnore
    private Integer limitNum;

    /**
     * 货币缩写
     */
    private String currency;

    /**
     * 实付价格
     */
    private BigDecimal price;

    /**
     * 市场价格文字
     * 如:28元/年
     */
    private String marketPriceContent;

    /**
     * 折扣率
     */
    @JsonIgnore
    private Integer discountCoefficient;

    /**
     * 会员商品名称
     */
    private String title;

    /**
     * 会员商品描述
     */
    private String remark;

    /**
     * 标签文案
     */
    private String tags;

    /**
     * 是否是特殊商品
     */
    private String specialGoods;

    /**
     * 背景图片地址
     */
    private String backgroundUrl;

    /**
     * 优惠文案
     */
    private String preferentialCopywriter;

    /***/
    private Integer activeDays;
}