package com.ellabook.entity.order;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
@AllArgsConstructor
public class OrderHeader {
    private Integer id;

    private String uid;

    private String orderNo;

    private String tradeNo;

    private String transactionId;

    private String orderType;

    private String couponCode;

    private BigDecimal orderAmount;

    private BigDecimal payAmount;

    private Integer payPoints;

    private BigDecimal couponAmount;

    private Date payTime;

    private String orderStatus;

    private String status;

    private String paymentPlantform;

    private String codeUrl;

    private String orderSource;

    private String channelCode;
    private String currency;

    private Date finishedTime;

    private Date createTime;

    private Date expireTime;

    public OrderHeader() {
    }

    public OrderHeader(String uid, String orderNo, String orderType, String orderStatus, BigDecimal orderAmount, String status, String paymentPlantform, String channelCode, String currency, Date createTime) {
        this.uid = uid;
        this.orderNo = orderNo;
        this.orderType = orderType;
        this.orderStatus = orderStatus;
        this.orderAmount = orderAmount;
        this.status = status;
        this.paymentPlantform = paymentPlantform;
        this.channelCode = channelCode;
        this.currency = currency;
        this.createTime = createTime;
    }

    public OrderHeader(String uid, String tradeNo, String orderNo, String orderType, BigDecimal orderAmount, BigDecimal payAmount, String orderStatus, String status, String paymentPlantform, String channelCode, Date createTime) {
        this.uid = uid;
        this.tradeNo = tradeNo;
        this.orderNo = orderNo;
        this.orderType = orderType;
        this.orderAmount = orderAmount;
        this.payAmount = payAmount;
        this.orderStatus = orderStatus;
        this.status = status;
        this.paymentPlantform = paymentPlantform;
        this.channelCode = channelCode;
        this.createTime = createTime;
    }

    public OrderHeader(String uid, String orderNo, String tradeNo, String orderType, BigDecimal orderAmount, BigDecimal payAmount, Date payTime,
                       String orderStatus, String status, String currency, String channelCode, String paymentPlantform, Date finishedTime, Date createTime) {
        this.uid = uid;
        this.orderNo = orderNo;
        this.tradeNo = tradeNo;
        this.orderType = orderType;
        this.orderAmount = orderAmount;
        this.payAmount = payAmount;
        this.payTime = payTime;
        this.orderStatus = orderStatus;
        this.status = status;
        this.currency = currency;
        this.paymentPlantform = paymentPlantform;
        this.channelCode = channelCode;
        this.finishedTime = finishedTime;
        this.createTime = createTime;
    }

    public OrderHeader(String uid, String orderNo, String tradeNo, Date payTime, String paymentPlantform, String channelCode, Date finishedTime, Date createTime) {
        this.uid = uid;
        this.orderNo = orderNo;
        this.tradeNo = tradeNo;
        this.payTime = payTime;
        this.paymentPlantform = paymentPlantform;
        this.channelCode = channelCode;
        this.finishedTime = finishedTime;
        this.createTime = createTime;
    }
}