package com.ellabook.entity.order;

import com.ellabook.util.doc.annotations.FieldExplain;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class Goods {
    private Integer id;
    @FieldExplain(explain = "商品编码(如：G201712011019190751)")
    private String goodsCode;
    @FieldExplain(explain = "物品编码(如：B201801190311)")
    private String thirdCode;
    @FieldExplain(explain = "商品名称(如：点点乐园  儿歌（下）)")
    private String goodsName;
    @FieldExplain(explain = "商品优惠价格(如：0.99)")
    private BigDecimal goodsPrice;
    @FieldExplain(explain = "商品市场价格(如：12.80)")
    private BigDecimal goodsMarketprice;
    @FieldExplain(explain = "商品市场价格(如：12.80)")
    private Integer goodsIntegral;
    @FieldExplain(explain = "商品积分价(如：2)")
    private BigDecimal goodsSrcPrice;
    @FieldExplain(explain = "ios商品价格id(如：ellaellabookRMB0015)")
    private String iosPriceId;
    @FieldExplain(explain = "ios商品价格(该字段暂时未使用，有专门的渠道表设置渠道价格)")
    private BigDecimal iosPrice;
    @FieldExplain(explain = "销售数量，该字段未使用(如：5)")
    private Integer goodsSalenum;
    @FieldExplain(explain = "商品库存，该字段未使用(如：0)")
    private Integer goodsStorage;
    @FieldExplain(explain = "商品类型 BOOK-图书 LIB-图书馆 BOOK_PACKAGE-图书包 ELLA_VIP-会员 ELLA_COIN-咿啦币(如：BOOK)")
    private String goodsType;
    @FieldExplain(explain = "商品状态 SHELVES_WAIT:待上架 ,SHELVES_ON:已上架,SHELVES_OFF;已下架,PRE_SALE:预售(如：SHELVES_ON)")
    private String goodsState;
    @FieldExplain(explain = "创建时间")
    private Date createTime;
    @FieldExplain(explain = "修改时间")
    private Date updateTime;
    @FieldExplain(explain = "结束时间")
    private Date expireTime;
    @FieldExplain(explain = "数据状态  EXCEPTION:删除 ,NORMAL:正常(如：NORMAL)")
    private String status;
    @FieldExplain(explain = "上架时间")
    private Date goodsPublishTime;
    private String currency;
    @FieldExplain(explain = "下架时间")
    private Date goodsUnpublishTime;
    private String goodsSubstance;
    private String expand1;
    private String expand2;
    private String expand3;
    private String expand4;
    private String expand5;

    public Goods() {
    }

    public Goods(String thirdCode, String goodsName, BigDecimal goodsPrice, BigDecimal goodsMarketprice, BigDecimal goodsSrcPrice,
                 String iosPriceId, BigDecimal iosPrice,
                 Integer goodsSalenum, Integer goodsStorage, String goodsType, String goodsState, Date createTime, Date goodsPublishTime) {
        this.thirdCode = thirdCode;
        this.goodsName = goodsName;
        this.goodsPrice = goodsPrice;
        this.goodsMarketprice = goodsMarketprice;
        this.goodsSrcPrice = goodsSrcPrice;
        this.iosPriceId = iosPriceId;
        this.iosPrice = iosPrice;
        this.goodsSalenum = goodsSalenum;
        this.goodsStorage = goodsStorage;
        this.goodsType = goodsType;
        this.goodsState = goodsState;
        this.createTime = createTime;
        this.goodsPublishTime = goodsPublishTime;
    }
}