package com.ellabook.entity.operation.dto;

import com.ellabook.util.parameterChecking.NotBlank;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

public class RedeemCodeDTO {

    @NotBlank(value = "兑换码类型不能为空")
    private String redeemCodeType;

    @NotBlank(value = "兑换码创建数量不能为空")
    private Integer createNum;//创建数量

    @NotBlank(value = "兑换码文件名称不能为空")
    private String createName;//创建文件名称

    @NotBlank(value = "兑换失效时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expireTime;//失效时间

    private Integer redeemCodeLength = 10;

    private String ipCardEventId;
    private String cardCode;
    private String url;
    private String batch;
    private String activityName;

    //借阅活动编码
    private String borrowCardEventId;
    //激活天数
    private Integer activeTime;

    private String activityCode;

    public String getRedeemCodeType() {
        return redeemCodeType;
    }

    public void setRedeemCodeType(String redeemCodeType) {
        this.redeemCodeType = redeemCodeType;
    }

    public Integer getCreateNum() {
        return createNum;
    }

    public void setCreateNum(Integer createNum) {
        this.createNum = createNum;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getRedeemCodeLength() {
        return redeemCodeLength;
    }

    public String getIpCardEventId() {
        return ipCardEventId;
    }

    public void setIpCardEventId(String ipCardEventId) {
        this.ipCardEventId = ipCardEventId;
    }

    public void setRedeemCodeLength(Integer redeemCodeLength) {
        this.redeemCodeLength = redeemCodeLength;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCardCode() {
        return cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getBorrowCardEventId() {
        return borrowCardEventId;
    }

    public void setBorrowCardEventId(String borrowCardEventId) {
        this.borrowCardEventId = borrowCardEventId;
    }

    public Integer getActiveTime() {
        return activeTime;
    }

    public void setActiveTime(Integer activeTime) {
        this.activeTime = activeTime;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }
}
