package com.ellabook.entity.operation;

import com.ellabook.util.parameterChecking.NotBlank;

import java.util.Date;

/**
 * Description:    任务实体类
 * Author:         lyy
 * CreateDate:     2018/10/25 11:21
 */
public class OperationTask {

    private Integer id;
    private String taskCode;//任务编号
    @NotBlank(value = "任务名称不能为空")
    private String taskName;//任务名称
    @NotBlank(value = "任务描述不能为空")
    private String taskDesc;//任务描述
    @NotBlank(value = "任务图标不能为空")
    private String taskImageUrl;//任务图标
    @NotBlank(value = "任务类型不能为空")
    private String taskType;//任务的行为类型（`ACTIVE_TASK`:活跃任务 `READ_TASK`:阅读任务 `PAID_BEHAVIOR_TASK`:付费行为 `SOCIAL_PROPAGATE`:社交传播）
    @NotBlank(value = "任务行为不能为空")
    private String actionCode;//任务行为编号
    private String taskParam;//具体行为参数 ,json格式
    private Date startTime;//任务开始时间（接取时间）
    private Date endTime;//任务结束时间（完成时间）
    @NotBlank(value = "任务领取类型不能为空")
    private String taskAcceptType;//任务领取类型（`AUTO`:自动领取 `HAND`:手动领取）
    @NotBlank(value = "励领领取类型不能为空")
    private String rewardsAcceptType;//励领取类型（`AUTO`:自动领取 `HAND`:手动领取）
    //    @NotBlank(value = "循环周期不能为空")
    private Integer cycleTime;//循环任务周期，单位/秒
    private String cycleType;//循环类型（YES/NO） 非数据库字段
    //    @NotBlank(value = "周期内完成次数不能为空")
    private Integer finishTimes;//周期内完成次数
    private String showFlag;//展示状态   SHOW_ON:已展示(已添加至任务墙中并发布),SHOW_OFF:未展示(未添加至任务墙),SHOW_WAIT:待展示（已添加至任务墙未发布）,SHOW_UNSHELVE:发布后移除（已添加至任务墙发布后移除）
    private String status;//数据状态（`NORAML`:正常 `EXCEPTION`:异常）
    private Date createTime;//创建时间
    private Date updateTime;//修改时间

    private String expireStatus;//过期状态  已过期：EXPIRED_YES，未过期：EXPIRED_NO

    private OperationTaskReward taskReward;//奖励

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDesc() {
        return taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public String getTaskImageUrl() {
        return taskImageUrl;
    }

    public void setTaskImageUrl(String taskImageUrl) {
        this.taskImageUrl = taskImageUrl;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getActionCode() {
        return actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    public String getTaskParam() {
        return taskParam;
    }

    public void setTaskParam(String taskParam) {
        this.taskParam = taskParam;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getTaskAcceptType() {
        return taskAcceptType;
    }

    public void setTaskAcceptType(String taskAcceptType) {
        this.taskAcceptType = taskAcceptType;
    }

    public String getRewardsAcceptType() {
        return rewardsAcceptType;
    }

    public void setRewardsAcceptType(String rewardsAcceptType) {
        this.rewardsAcceptType = rewardsAcceptType;
    }

    public String getShowFlag() {
        return showFlag;
    }

    public void setShowFlag(String showFlag) {
        this.showFlag = showFlag;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getCycleTime() {
        return cycleTime;
    }

    public void setCycleTime(Integer cycleTime) {
        this.cycleTime = cycleTime;
    }

    public Integer getFinishTimes() {
        return finishTimes;
    }

    public void setFinishTimes(Integer finishTimes) {
        this.finishTimes = finishTimes;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public OperationTaskReward getTaskReward() {
        return taskReward;
    }

    public void setTaskReward(OperationTaskReward taskReward) {
        this.taskReward = taskReward;
    }

    public String getCycleType() {
        return cycleType;
    }

    public void setCycleType(String cycleType) {
        this.cycleType = cycleType;
    }

    public String getExpireStatus() {
        return expireStatus;
    }

    public void setExpireStatus(String expireStatus) {
        this.expireStatus = expireStatus;
    }
}
