package com.ellabook.entity.operation;

import com.ellabook.util.parameterChecking.CheckValue;
import com.ellabook.util.parameterChecking.NotEmpty;

import java.util.Date;

public class AgentSchool {
    private Long id;

    private String schoolCode;

    @NotEmpty
    @CheckValue("^.{1,32}$")
    private String schoolName;

    @NotEmpty
    @CheckValue()
    private String country;

    private String province;

    private String city;

    @NotEmpty
    @CheckValue("^.{3,64}$")
    private String schoolAddress;

    private String agentCode;

    @CheckValue()
    private Integer maxStudentNum;

    private String introduction;

    private String consultContacter;

    @NotEmpty
    @CheckValue("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$")
    private String email;

    private String phone;

    @NotEmpty
    @CheckValue()
    private Byte shareRatio;

    private Byte discountRate;

    private String status;

    private String remark;

    private Date createTime;

    private Date updateTime;

    @NotEmpty
    @CheckValue()
    private Date cooperateStartTime;

    @NotEmpty
    @CheckValue()
    private Date cooperateEndTime;

    @NotEmpty
    @CheckValue()
    private String cooperateStatus;

    private String inviteUrl;

    private String coverPicUrl;

    private Integer registerNum;

    public String getCoverPicUrl() {
        return coverPicUrl;
    }

    public void setCoverPicUrl(String coverPicUrl) {
        this.coverPicUrl = coverPicUrl;
    }

    public Integer getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Integer registerNum) {
        this.registerNum = registerNum;
    }

    public String getInviteUrl() {
        return inviteUrl;
    }

    public void setInviteUrl(String inviteUrl) {
        this.inviteUrl = inviteUrl;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSchoolCode() {
        return schoolCode;
    }

    public void setSchoolCode(String schoolCode) {
        this.schoolCode = schoolCode == null ? null : schoolCode.trim();
    }

    public String getSchoolName() {
        return schoolName;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName == null ? null : schoolName.trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country == null ? null : country.trim();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province == null ? null : province.trim();
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city == null ? null : city.trim();
    }

    public String getSchoolAddress() {
        return schoolAddress;
    }

    public void setSchoolAddress(String schoolAddress) {
        this.schoolAddress = schoolAddress == null ? null : schoolAddress.trim();
    }

    public String getAgentCode() {
        return agentCode;
    }

    public void setAgentCode(String agentCode) {
        this.agentCode = agentCode == null ? null : agentCode.trim();
    }

    public Integer getMaxStudentNum() {
        return maxStudentNum;
    }

    public void setMaxStudentNum(Integer maxStudentNum) {
        this.maxStudentNum = maxStudentNum;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction == null ? null : introduction.trim();
    }

    public String getConsultContacter() {
        return consultContacter;
    }

    public void setConsultContacter(String consultContacter) {
        this.consultContacter = consultContacter == null ? null : consultContacter.trim();
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    public Byte getShareRatio() {
        return shareRatio;
    }

    public void setShareRatio(Byte shareRatio) {
        this.shareRatio = shareRatio;
    }

    public Byte getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Byte discountRate) {
        this.discountRate = discountRate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getCooperateStartTime() {
        return cooperateStartTime;
    }

    public void setCooperateStartTime(Date cooperateStartTime) {
        this.cooperateStartTime = cooperateStartTime;
    }

    public Date getCooperateEndTime() {
        return cooperateEndTime;
    }

    public void setCooperateEndTime(Date cooperateEndTime) {
        this.cooperateEndTime = cooperateEndTime;
    }

    public String getCooperateStatus() {
        return cooperateStatus;
    }

    public void setCooperateStatus(String cooperateStatus) {
        this.cooperateStatus = cooperateStatus == null ? null : cooperateStatus.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}