package com.ellabook.entity.listenBook.DTO;

import com.ellabook.util.DateUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
public class QueryBookAudioDto extends PageDto {

    /**
     * 时间格式正则
     */
    private static final String DATE_REG = "^[1-9]\\d{3}-(0[1-9]|1[0-2])$";

    private Date addTime;

    private String classCode;

    private String authorCode;

    private String publishCode;

    private String audioName;

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(String addTime) {
        if (StringUtils.isBlank(addTime) || !addTime.matches(DATE_REG)) {
            return;
        }
        this.addTime = DateUtil.stringToDate(addTime, DateUtil.DEFAULT_DATE_FORMAT);
    }

    public String getClassCode() {
        return classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = StringUtils.isBlank(classCode) ? null : classCode.trim();
    }

    public String getAuthorCode() {
        return authorCode;
    }

    public void setAuthorCode(String authorCode) {
        this.authorCode = StringUtils.isBlank(authorCode) ? null : authorCode.trim();
    }

    public String getPublishCode() {
        return publishCode;
    }

    public void setPublishCode(String publishCode) {
        this.publishCode = StringUtils.isBlank(publishCode) ? null : publishCode.trim();
    }

    public String getAudioName() {
        return audioName;
    }

    public void setAudioName(String audioName) {
        this.audioName = StringUtils.isBlank(audioName) ? null : audioName.trim();
    }
}
