package com.ellabook.entity.listenBook.DTO;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class LbAppDto implements Serializable {

    private static final long serialVersionUID = -6767044078991879113L;

    /**
     * 模块code
     */
    private String partCode;

    /**
     * 模块title
     */
    private String partTitle;

    /**
     * 模块类别(WIKI-分类管理，，AD-广告横幅，LISTEN_LIST-听单,LISTEN_ARRAY-听单合集)
     */
    private String partType;

    /**
     * 模块序号
     */
    private String partSourceNum;

    /**
     * 模块移动类别
     */
    private String partMoveType;

    /**
     * 模块风格
     */
    private String partStyle;

    /**
     * 模块跳转风格 （(JUMP_CURRENT：跳转当前)）
     */
    private String targetStyle;

    /**
     * 模块跳转类型 (SYSTEM_INTERFACE:系统界面 ,LISTEN:听单)
     */
    private String targetType;

    /**
     * 模块跳转文字描述
     */
    private String targetDesc;

    /**
     * 模块跳转路由
     */
    private String targetPage;


    /**
     * 听书广告横幅
     */
    private LbAdDto ads;

    /**
     * 听单信息
     */
    private LbListenAppDto listenDto;

    /**
     * 分类列表
     */
    private List<LbSortDto> sorts;

    private String platform;

    private String language;
}
