package com.ellabook.entity.library;

import com.ellabook.util.HttpConnectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatTools {
    private static Logger log = LoggerFactory.getLogger(HttpConnectUtil.class);

    /**
     * 获取微信统一下单接口签名
     * out_trade_no		交易流水号
     * cardType			VIP卡类型
     * price				VIP卡价格
     * memberIP			用户IP
     * openid			微信获取openid
     * trade_type		交易类型：JSAPI，NATIVE，APP
     * map				记录所有统一支付参数map
     *
     * @return 返回签名
     */
    public static String getUnifieDorderSign(WeChatUnifieDorderParam param) {

        //将参数都保存进map中
        param.toMap();
        String sign = HttpConnectUtil.createWechatSign(param.getMap(), param.getKey());
        param.getMap().put("sign", sign);
        log.debug("微信签名为：" + sign);

        return sign;
    }
}
