package com.ellabook.entity.home.vo;

import com.alibaba.fastjson.annotation.JSONField;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @author junboxiang
 * @Description: 幼儿园数据统计 vo
 * @date 20L18/7/18
 */
public class KindergartenDataStatisticVo {

    /**
     * 幼儿园编码
     */
    private String kindergartenCode;

    /**
     * 幼儿园名称
     */
    @Excel(name = "幼儿园", width = 30)
    private String kindergartenName;

    /**
     * 幼儿园地址
     */
    @Excel(name = "地址", orderNum = "1", width = 30)
    private String kindergartenAddress;

    /**
     * 班级总数
     */
    @Excel(name = "班级", orderNum = "2")
    private Long classNum = 0L;

    /**
     * 年卡数量
     */
    @JSONField(serialize = false)
    @Excel(name = "年卡", orderNum = "3")
    private Long yearVipCardNum = 0L;

    /**
     * 半年卡数量
     */
    @Excel(name = "半年卡", orderNum = "4")
    @JSONField(serialize = false)
    private Long halfYearVipCardNum = 0L;

    /**
     * 教师数量
     */
    @Excel(name = "教师", orderNum = "5")
    private Long teacherNum = 0L;

    /**
     * 指定时间段内活跃教师数量
     */
    @Excel(name = "活跃教师", orderNum = "6")
    private Long activeTeacherNum = 0L;

    /**
     * 指定时间段内发送作业教师
     */
    @Excel(name = "发送作业教师", orderNum = "7", width = 20)
    private Long sendHomeTaskTeacherNum = 0L;

    /**
     * 指定时间段内幼儿园发送作业总数
     */
    @Excel(name = "发送作业", orderNum = "8")
    private Long sendHomeTaskNum = 0L;

    /**
     * 指定区间内评论作业的老师数量
     */
    @JSONField(serialize = false)
    @Excel(name = "评论作业教师", orderNum = "9", width = 20)
    private Long homeTaskTeacherCommentNum = 0L;

    /**
     * 指定区间内幼儿园教师产生的作业评论总数
     */
    @JSONField(serialize = false)
    @Excel(name = "作业评论", orderNum = "10")
    private Long homeTaskCommentNum = 0L;

    /**
     * 家长数量
     */
    @Excel(name = "家长", orderNum = "11")
    private Long parentNum = 0L;

    /**
     * 指定区间内活跃家长数量
     */
    @Excel(name = "活跃家长数量", orderNum = "12", width = 20)
    private Long activeParentNum = 0L;

    /**
     * 指定区间完成作业家长
     */
    @Excel(name = "完成作业家长", orderNum = "13", width = 20)
    private Long performHomeTaskParentNum = 0L;

    /**
     * 指定区间内家长幼儿园家长看书数量
     */
    @JSONField(serialize = false)
    @Excel(name = "家长看书", orderNum = "14")
    private Long parentReadBookNum = 0L;

    /**
     * 业务员民名称
     */
    @JSONField(serialize = false)
    @Excel(name = "业务员", orderNum = "15", width = 20)
    private String salesmanName;

    /**
     * 业务员联系方式
     */
    @JSONField(serialize = false)
    @Excel(name = "业务员联系方式", orderNum = "16", width = 20)
    private String salesmanPhone;

    /**
     * 幼儿园vip卡总数量 年卡+半年卡
     */
    private Long vipCardNum = 0L;

    public String getKindergartenCode() {
        return kindergartenCode;
    }

    public KindergartenDataStatisticVo setKindergartenCode(String kindergartenCode) {
        this.kindergartenCode = kindergartenCode;
        return this;
    }

    public String getKindergartenName() {
        return kindergartenName;
    }

    public KindergartenDataStatisticVo setKindergartenName(String kindergartenName) {
        this.kindergartenName = kindergartenName;
        return this;
    }

    public String getKindergartenAddress() {
        return kindergartenAddress;
    }

    public KindergartenDataStatisticVo setKindergartenAddress(String kindergartenAddress) {
        this.kindergartenAddress = kindergartenAddress;
        return this;
    }

    public Long getClassNum() {
        return classNum;
    }

    public KindergartenDataStatisticVo setClassNum(Long classNum) {
        this.classNum = classNum;
        return this;
    }

    public Long getYearVipCardNum() {
        return yearVipCardNum;
    }

    public KindergartenDataStatisticVo setYearVipCardNum(Long yearVipCardNum) {
        this.yearVipCardNum = yearVipCardNum;
        return this;
    }

    public Long getHalfYearVipCardNum() {
        return halfYearVipCardNum;
    }

    public KindergartenDataStatisticVo setHalfYearVipCardNum(Long halfYearVipCardNum) {
        this.halfYearVipCardNum = halfYearVipCardNum;
        return this;
    }

    public Long getTeacherNum() {
        return teacherNum;
    }

    public KindergartenDataStatisticVo setTeacherNum(Long teacherNum) {
        this.teacherNum = teacherNum;
        return this;
    }

    public Long getActiveTeacherNum() {
        return activeTeacherNum;
    }

    public KindergartenDataStatisticVo setActiveTeacherNum(Long activeTeacherNum) {
        this.activeTeacherNum = activeTeacherNum;
        return this;
    }

    public Long getSendHomeTaskTeacherNum() {
        return sendHomeTaskTeacherNum;
    }

    public KindergartenDataStatisticVo setSendHomeTaskTeacherNum(Long sendHomeTaskTeacherNum) {
        this.sendHomeTaskTeacherNum = sendHomeTaskTeacherNum;
        return this;
    }

    public Long getSendHomeTaskNum() {
        return sendHomeTaskNum;
    }

    public KindergartenDataStatisticVo setSendHomeTaskNum(Long sendHomeTaskNum) {
        this.sendHomeTaskNum = sendHomeTaskNum;
        return this;
    }

    public Long getHomeTaskTeacherCommentNum() {
        return homeTaskTeacherCommentNum;
    }

    public KindergartenDataStatisticVo setHomeTaskTeacherCommentNum(Long homeTaskTeacherCommentNum) {
        this.homeTaskTeacherCommentNum = homeTaskTeacherCommentNum;
        return this;
    }

    public Long getHomeTaskCommentNum() {
        return homeTaskCommentNum;
    }

    public KindergartenDataStatisticVo setHomeTaskCommentNum(Long homeTaskCommentNum) {
        this.homeTaskCommentNum = homeTaskCommentNum;
        return this;
    }

    public Long getParentNum() {
        return parentNum;
    }

    public KindergartenDataStatisticVo setParentNum(Long parentNum) {
        this.parentNum = parentNum;
        return this;
    }

    public Long getActiveParentNum() {
        return activeParentNum;
    }

    public KindergartenDataStatisticVo setActiveParentNum(Long activeParentNum) {
        this.activeParentNum = activeParentNum;
        return this;
    }

    public Long getPerformHomeTaskParentNum() {
        return performHomeTaskParentNum;
    }

    public KindergartenDataStatisticVo setPerformHomeTaskParentNum(Long performHomeTaskParentNum) {
        this.performHomeTaskParentNum = performHomeTaskParentNum;
        return this;
    }

    public Long getParentReadBookNum() {
        return parentReadBookNum;
    }

    public KindergartenDataStatisticVo setParentReadBookNum(Long parentReadBookNum) {
        this.parentReadBookNum = parentReadBookNum;
        return this;
    }

    public String getSalesmanName() {
        return salesmanName;
    }

    public KindergartenDataStatisticVo setSalesmanName(String salesmanName) {
        this.salesmanName = salesmanName;
        return this;
    }

    public String getSalesmanPhone() {
        return salesmanPhone;
    }

    public KindergartenDataStatisticVo setSalesmanPhone(String salesmanPhone) {
        this.salesmanPhone = salesmanPhone;
        return this;
    }

    public Long getVipCardNum() {
        return vipCardNum;
    }

    public KindergartenDataStatisticVo setVipCardNum(Long vipCardNum) {
        this.vipCardNum = vipCardNum;
        return this;
    }
}
