package com.ellabook.entity.home.vo;

import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @author junboxiang
 * @Description: 业务数据 - 根据幼儿园code统计班级数据 vo
 * @date 2018/7/23
 */
public class ClassDataStatisticVo {

    /**
     * 幼儿园名称
     */
    @Excel(name = "幼儿园", width = 30)
    private String kindergartenName;

    /**
     * 幼儿园地址
     */
    @Excel(name = "地址", orderNum = "1", width = 30)
    private String kindergartenAddress;

    /**
     * 班级编码
     */
    private String classCode;

    /**
     * 班级总数
     */
    @Excel(name = "班级名称", orderNum = "2")
    private String className;

    /**
     * 年级名称
     */
    @Excel(name = "年级", orderNum = "3")
    private String gradeName;

    /**
     * 年卡数量
     */
    @Excel(name = "年卡", orderNum = "4")
    private Long yearVipCardNum = 0L;

    /**
     * 半年卡数量
     */
    @Excel(name = "半年卡", orderNum = "5")
    private Long halfYearVipCardNum = 0L;

    /**
     * 幼儿园vip卡总数量 年卡+半年卡
     */
    private Long vipCardNum = 0L;

    /**
     * 教师数量
     */
    @Excel(name = "教师", orderNum = "6")
    private Long teacherNum = 0L;

    /**
     * 指定时间段内班级发送作业总数
     */
    @Excel(name = "发送作业", orderNum = "7")
    private Long sendHomeTaskNum = 0L;

    /**
     * 指定区间内班级教师产生的作业评论总数
     */
    @Excel(name = "作业评论", orderNum = "8")
    private Long homeTaskCommentNum = 0L;

    /**
     * 家长数量
     */
    @Excel(name = "家长", orderNum = "9")
    private Long parentNum = 0L;

    /**
     * 指定区间内活跃家长数量
     */
    @Excel(name = "活跃家长", orderNum = "10", width = 20)
    private Long activeParentNum = 0L;

    /**
     * 指定区间完成作业家长
     */
    @Excel(name = "完成作业家长", orderNum = "11", width = 20)
    private Long performHomeTaskParentNum = 0L;

    /**
     * 指定区间内家长班级内家长看书数量
     */
    @Excel(name = "家长看书", orderNum = "12")
    private Long parentReadBookNum = 0L;

    public String getKindergartenName() {
        return kindergartenName;
    }

    public ClassDataStatisticVo setKindergartenName(String kindergartenName) {
        this.kindergartenName = kindergartenName;
        return this;
    }

    public String getKindergartenAddress() {
        return kindergartenAddress;
    }

    public ClassDataStatisticVo setKindergartenAddress(String kindergartenAddress) {
        this.kindergartenAddress = kindergartenAddress;
        return this;
    }

    public String getClassName() {
        return className;
    }

    public ClassDataStatisticVo setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getGradeName() {
        return gradeName;
    }

    public ClassDataStatisticVo setGradeName(String gradeName) {
        this.gradeName = gradeName;
        return this;
    }


    public Long getYearVipCardNum() {
        return yearVipCardNum;
    }

    public ClassDataStatisticVo setYearVipCardNum(Long yearVipCardNum) {
        this.yearVipCardNum = yearVipCardNum;
        return this;
    }

    public Long getHalfYearVipCardNum() {
        return halfYearVipCardNum;
    }

    public ClassDataStatisticVo setHalfYearVipCardNum(Long halfYearVipCardNum) {
        this.halfYearVipCardNum = halfYearVipCardNum;
        return this;
    }

    public Long getVipCardNum() {
        return vipCardNum;
    }

    public ClassDataStatisticVo setVipCardNum(Long vipCardNum) {
        this.vipCardNum = vipCardNum;
        return this;
    }

    public Long getTeacherNum() {
        return teacherNum;
    }

    public ClassDataStatisticVo setTeacherNum(Long teacherNum) {
        this.teacherNum = teacherNum;
        return this;
    }

    public Long getSendHomeTaskNum() {
        return sendHomeTaskNum;
    }

    public ClassDataStatisticVo setSendHomeTaskNum(Long sendHomeTaskNum) {
        this.sendHomeTaskNum = sendHomeTaskNum;
        return this;
    }

    public Long getHomeTaskCommentNum() {
        return homeTaskCommentNum;
    }

    public ClassDataStatisticVo setHomeTaskCommentNum(Long homeTaskCommentNum) {
        this.homeTaskCommentNum = homeTaskCommentNum;
        return this;
    }

    public Long getParentNum() {
        return parentNum;
    }

    public ClassDataStatisticVo setParentNum(Long parentNum) {
        this.parentNum = parentNum;
        return this;
    }

    public Long getActiveParentNum() {
        return activeParentNum;
    }

    public ClassDataStatisticVo setActiveParentNum(Long activeParentNum) {
        this.activeParentNum = activeParentNum;
        return this;
    }

    public Long getPerformHomeTaskParentNum() {
        return performHomeTaskParentNum;
    }

    public ClassDataStatisticVo setPerformHomeTaskParentNum(Long performHomeTaskParentNum) {
        this.performHomeTaskParentNum = performHomeTaskParentNum;
        return this;
    }

    public Long getParentReadBookNum() {
        return parentReadBookNum;
    }

    public ClassDataStatisticVo setParentReadBookNum(Long parentReadBookNum) {
        this.parentReadBookNum = parentReadBookNum;
        return this;
    }

    public String getClassCode() {
        return classCode;
    }

    public ClassDataStatisticVo setClassCode(String classCode) {
        this.classCode = classCode;
        return this;
    }
}
