package com.ellabook.entity.book.vo;

import com.ellabook.entity.book.Book;
import com.ellabook.entity.book.UserReadPresentation;
import lombok.*;

import java.util.ArrayList;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserReadPresentationVO extends UserReadPresentation {
    /**
     * 用户昵称
     */
    private String userNick;
    /**
     * 用户头像
     */
    private String userAvatar;

    //    private Integer ipImageNo;
    /**
     * IP形象名称
     */
    private String ipImageName;
    /**
     * 宝宝姓名
     */
    private List<String> childrenNameList = new ArrayList<>();
    /**
     * 最爱看的分类名称
     */
    private String mostReadWikiName;
    /**
     * 最爱看的图书名称
     */
    private String mostReadBookName;
    /**
     * 最爱看的图书封面
     */
    private String mostReadConvert;

    /**
     * 最爱看的分类 book列表
     */
    private List<Book> bookListForMostReadWiki = new ArrayList<>();
}