package com.ellabook.entity.book.dto;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

public class UserInterestDto {

    private String interestType;
    private String uid;
    private String interestCode;
    private String interestName;
    private Map<String, Double> actionScores;
    private Date lastActiveTime;
    private double score;
    private Double total;

    public UserInterestDto() {
    }

    public UserInterestDto(String interestType, String interestCode, String interestName, Map<String, Double> actionScores, Date lastActiveTime, double score) {
        this.interestType = interestType;
        this.interestCode = interestCode;
        this.interestName = interestName;
        this.actionScores = actionScores;
        this.lastActiveTime = lastActiveTime;
        this.score = score;
    }

    public double getTotalScore() {
        if (total == null) {
            if (actionScores == null || actionScores.size() < 1) {
                total = score;
                return total;
            }
            Double totalActionScores = actionScores.values().stream().collect(Collectors.summingDouble(s -> s));
            total = totalActionScores.doubleValue() + score;

        }
        return total == null ? -1D : total;
    }

    public Map<String, Double> getActionScores() {
        return actionScores;
    }

    public void setActionScores(Map<String, Double> actionScores) {
        this.actionScores = actionScores;
    }

    public String getInterestType() {
        return interestType;
    }

    public void setInterestType(String interestType) {
        this.interestType = interestType;
    }

    public String getInterestCode() {
        return interestCode;
    }

    public void setInterestCode(String interestCode) {
        this.interestCode = interestCode;
    }

    public String getInterestName() {
        return interestName;
    }

    public void setInterestName(String interestName) {
        this.interestName = interestName;
    }

    public Date getLastActiveTime() {
        return lastActiveTime;
    }

    public void setLastActiveTime(Date lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public double getScore() {
        return score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Double getTotal() {
        return total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }
}
