package com.ellabook.entity.book.dto;

import com.ellabook.entity.book.BaseBook;

import java.io.Serializable;
import java.math.BigDecimal;

public class UserInterestBookDto extends BaseBook implements Serializable {

    private BigDecimal goodsPrice;

    private Integer days;

    public double getSortScore() {
        Integer readNum = getReadNum();
        if (readNum <= 0) {
            return 0D;
        }
        double goodsPriceScore = goodsPrice.doubleValue() > 0D ? 1.5D : 1D;
        double daysScore = 0D;
        if (0 <= days && days <= 7) {
            daysScore = 2D;
        } else if (8 <= days && days <= 30) {

            daysScore = 1D;
        } else if (days > 30) {

            daysScore = 0.5D;
        }
        return readNum * goodsPriceScore * daysScore;
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }
}