package com.ellabook.entity.book.dto;

import com.ellabook.entity.analysis.AppLogsHostEvent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAppEventsDto {

    private String id;
    private boolean noLog = false;
    private List<AppLogsHostEvent> appEvents = new ArrayList<>();

    public UserAppEventsDto(String id) {
        this.id = id;
    }

    public Set<String> getBookCodes() {
        if (CollectionUtils.isEmpty(appEvents)) {
            return new HashSet<>();
        }
        return appEvents.stream().map(AppLogsHostEvent::getMsg).filter(msg -> StringUtils.isNotBlank(msg)).collect(Collectors.toSet());
    }

//    public void addEvents(List<AppLogsHostEvent> events) {
//        if (CollectionUtils.isEmpty(appEvents)) {
//            this.appEvents = new ArrayList<>();
//        }
//        if (!CollectionUtils.isEmpty(events)) {
//            this.appEvents.addAll(events);
//        }
//    }

    public void addEvent(AppLogsHostEvent appLogsHostEvent) {
        this.appEvents.add(appLogsHostEvent);
    }
}
