package com.ellabook.entity.book.dto;

import com.ellabook.entity.book.Book;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.util.Date;

/**
 * @Author: Ch
 * @Description: 合集的图书 dto
 * @Date:Created 2018/11/20 11:31
 * @Modified By:
 */
@EqualsAndHashCode(callSuper = true)
@Builder
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)//book
public class SeriesBookDTO extends Book {
    private String seriesCode;
    @Getter
    private String bookletName;
    private Integer idx;

    //series
    private String seriesName;
    private String seriesType;
    private Date bookSeriesCreateTime;

    public String takeSeriesCode() {
        return seriesCode;
    }

    public String takeSeriesName() {
        return seriesName;
    }

    public Integer takeSeriesBookIdx() {
        return idx;
    }

    public Date takeBookSeriesCreateTime() {
        return bookSeriesCreateTime;
    }

    public String takeSeriesType() {
        return seriesType;
    }

    public boolean checkSeriesType() {
        return "SAME_DIVERSITY".equalsIgnoreCase(seriesType);
    }
}