package com.ellabook.entity.book.dto;

import com.ellabook.entity.PublicParam;
import com.ellabook.entity.book.BookSubject;
import com.ellabook.entity.user.vo.PageVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

import java.util.Optional;

@EqualsAndHashCode(callSuper = true)
//@Builder
@Data
@NoArgsConstructor
//@AllArgsConstructor
public class BookSubjectDTO extends BookSubject {
    private Integer page;
    private Integer pageSize;
    private PageVo pageVo = new PageVo();

    private String channelCode;
    private String platform;
    private String uid;
    private PublicParam publicParam = new PublicParam();

    private String bookStudySourceTypes;
    private String packageCode;
    private double goodsDiscount;

    private String siteCode;
    private String language;

    /**
     * 请求类型 OPEN_VIP_RENT 开通会员并重租 ，默认DETAIL_RENT 详情租阅
     */
    private String requestType = "DETAIL_RENT";

    public BookSubjectDTO(PageVo pageVo, String channelCode, String platform) {
        this.pageVo = pageVo;
        this.channelCode = channelCode;
        this.platform = platform;
    }

    public BookSubjectDTO(PageVo pageVo, String channelCode, String platform, String siteCode) {
        this.pageVo = pageVo;
        this.channelCode = channelCode;
        this.platform = platform;
        this.siteCode = siteCode;
    }

    public void updateParam(int pageSize) {
        pageVo.setPage(Optional.ofNullable(page).orElse(0));//>=0
        pageVo.setPageSize(Optional.ofNullable(this.pageSize).orElse(pageSize));
        pageVo.setStartAndEnd();

//        if (publicParam != null) {
//            setChannelCode(publicParam.getChannelCode());
//            setPlatform(publicParam.getPlatform());
//            setUid(publicParam.getUid());
//        }
    }

    public String getChannelCode() {
        return StringUtils.isNotBlank(channelCode) ? channelCode : publicParam == null ? null : publicParam.getChannelCode();
    }

    public String getPlatform() {
        return StringUtils.isNotBlank(platform) ? platform : publicParam == null ? null : publicParam.getPlatform();
    }

    public String getUid() {
        return StringUtils.isNotBlank(uid) ? uid : publicParam == null ? null : publicParam.getUid();
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}