package com.ellabook.entity.book.dto;

import com.ellabook.entity.book.BookSeries;
import com.ellabook.entity.book.BookSeriesPreviewResource;
import lombok.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/11/20 11:31
 * @Modified By:
 */
@EqualsAndHashCode(callSuper = true)
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class BookSeriesDTO extends BookSeries {
    @Getter
    private List<String> tagList = new ArrayList<>();
    @Getter
    private List<SeriesBookDTO> bookList = new ArrayList<>();
    @Getter
    private List<BookSeriesPreviewResource> previewResourceList = new ArrayList<>();
    @Getter
    private List<BookPrizeRelationDTO> prizeList = new ArrayList<>();
    private boolean delFromES = false;

    public BookSeriesDTO(boolean delFromES, String seriesCode) {
        this.delFromES = delFromES;
        super.setSeriesCode(seriesCode);
    }

    public BookSeriesDTO(String seriesCode, String seriesName, String seriesType, Date createTime, List<SeriesBookDTO> bookList) {
        super.setSeriesCode(seriesCode);
        super.setSeriesName(seriesName);
        super.setSeriesType(seriesType);
        super.setCreateTime(createTime);
        this.bookList = bookList;
    }

    public boolean checkSeriesType() {
        return "SAME_DIVERSITY".equalsIgnoreCase(super.getSeriesType());
    }

    public boolean toDel() {
        return delFromES;
    }
}
