package com.ellabook.entity.book.dto;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用于图书包的分成计算
 */
public class BookPackageSharingDto implements Serializable {

    private static final long serialVersionUID = -4945692494088285913L;
    private String bookCode;

    /**
     * 购买图书包之前，图书是否存在书房的标记
     */
    private String insertFlag = "false";

    private BigDecimal bookPrice;

    private BigDecimal payAmount;

    private BigDecimal percentNum;

    private String publishUid;

    public BookPackageSharingDto() {
    }

    public BookPackageSharingDto(String bookCode, String insertFlag) {
        this.bookCode = bookCode;
        this.insertFlag = insertFlag;
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode;
    }

    public String getInsertFlag() {
        return insertFlag;
    }

    public void setInsertFlag(String insertFlag) {
        this.insertFlag = insertFlag;
    }

    public BigDecimal getBookPrice() {
        return bookPrice;
    }

    public void setBookPrice(BigDecimal bookPrice) {
        this.bookPrice = bookPrice;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public String getPublishUid() {
        return publishUid;
    }

    public void setPublishUid(String publishUid) {
        this.publishUid = publishUid;
    }

    public BigDecimal getPercentNum() {
        return percentNum;
    }

    public void setPercentNum(BigDecimal percentNum) {
        this.percentNum = percentNum;
    }
}