package com.ellabook.entity.book;

import com.ellabook.entity.book.dto.AdBannerDto;
import com.ellabook.entity.book.vo.BookSubjectVO;
import com.ellabook.entity.course.dto.CourseDTO;
import com.ellabook.util.doc.annotations.FieldExplain;

import java.util.Date;
import java.util.List;

public class IndexPart extends IndexPartKey {
    @FieldExplain(explain = "栏目编号")
    private String partCode;
    @FieldExplain(explain = "栏目标题")
    private String partTitle;
    @FieldExplain(explain = "栏目描述")
    private String partDesc;
    @FieldExplain(explain = "栏目风格 <br/>`SLIDE_HORIZONTAL`:横向滑动,<br/>`SLIDE_PORTRAIT`:纵向滑动,<br/>`IMAGE_TEXT`:图文,<br/>`DAILY_BOOK`:每日绘本,BOOK_SUBJECT:图书专题")
    private String partStyle;
    @FieldExplain(explain = "`LIST_HAND`:手动列表, <br/>`LIST_AUTO`:自动列表")
    private String partType;
    @FieldExplain(explain = "展示数量")
    private Integer partSourceNum;
    @FieldExplain(explain = "跳转的目标类型  <br/>`BOOK_DETAIL`:图书详情,<br/>`H5`:H5页面,<br/>`SYSTEM_INTERFACE`:系统界面,<br/> `BOOK_LIST`:图书列表页,<br/>`COURSE_LIST`:课程列表页,<br/>, BOOK_SUBJECT_LIST:图书专题列表页")
    private String targetType;
    @FieldExplain(explain = "展示数据地址")
    private String partSource;
    @FieldExplain(explain = "跳转描述（如：查看全部）")
    private String targetDesc;
    @FieldExplain(explain = "跳转目标")
    private String targetPage;
    @FieldExplain(explain = "是否支持一键购买 YES:是 NO:否")
    private String oneClickBuyStatus;

    private String status;
    private String platform;
    private String bgImageUrl;
    private String bgImageUpUrl;
    private String operateCopy;
    private String role;

    private Date createTime;

    private AdBannerDto adBanner;

    private List<Book> bookList;

    private List<DailyBook> dailyList;

    private List<CourseDTO> courseList;

    private List<BookSubjectVO> bookSubjectList;

    public List<CourseDTO> getCourseList() {
        return courseList;
    }

    public void setCourseList(List<CourseDTO> courseList) {
        this.courseList = courseList;
    }

    public List<DailyBook> getDailyList() {
        return dailyList;
    }

    public void setDailyList(List<DailyBook> dailyList) {
        this.dailyList = dailyList;
    }

    public List<Book> getBookList() {
        return bookList;
    }

    public void setBookList(List<Book> bookList) {
        this.bookList = bookList;
    }

    public String getPartSource() {
        return partSource;
    }

    public void setPartSource(String partSource) {
        this.partSource = partSource;
    }

    public String getPartCode() {
        return partCode;
    }

    public void setPartCode(String partCode) {
        this.partCode = partCode == null ? null : partCode.trim();
    }

    public String getPartTitle() {
        return partTitle;
    }

    public void setPartTitle(String partTitle) {
        this.partTitle = partTitle == null ? null : partTitle.trim();
    }

    public String getPartStyle() {
        return partStyle;
    }

    public void setPartStyle(String partStyle) {
        this.partStyle = partStyle == null ? null : partStyle.trim();
    }

    public String getPartType() {
        return partType;
    }

    public void setPartType(String partType) {
        this.partType = partType == null ? null : partType.trim();
    }

    public Integer getPartSourceNum() {
        return partSourceNum;
    }

    public void setPartSourceNum(Integer partSourceNum) {
        this.partSourceNum = partSourceNum;
    }

    public String getTargetType() {
        return targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType == null ? null : targetType.trim();
    }

    public String getTargetDesc() {
        return targetDesc;
    }

    public void setTargetDesc(String targetDesc) {
        this.targetDesc = targetDesc == null ? null : targetDesc.trim();
    }

    public String getTargetPage() {
        return targetPage;
    }

    public void setTargetPage(String targetPage) {
        this.targetPage = targetPage == null ? null : targetPage.trim();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public AdBannerDto getAdBanner() {
        return adBanner;
    }

    public void setAdBanner(AdBannerDto adBanner) {
        this.adBanner = adBanner;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getOneClickBuyStatus() {
        return oneClickBuyStatus;
    }

    public void setOneClickBuyStatus(String oneClickBuyStatus) {
        this.oneClickBuyStatus = oneClickBuyStatus;
    }

    public String getBgImageUrl() {
        return bgImageUrl;
    }

    public void setBgImageUrl(String bgImageUrl) {
        this.bgImageUrl = bgImageUrl;
    }

    public String getBgImageUpUrl() {
        return bgImageUpUrl;
    }

    public void setBgImageUpUrl(String bgImageUpUrl) {
        this.bgImageUpUrl = bgImageUpUrl;
    }

    public String getOperateCopy() {
        return operateCopy;
    }

    public void setOperateCopy(String operateCopy) {
        this.operateCopy = operateCopy;
    }

    public List<BookSubjectVO> getBookSubjectList() {
        return bookSubjectList;
    }

    public void setBookSubjectList(List<BookSubjectVO> bookSubjectList) {
        this.bookSubjectList = bookSubjectList;
    }

    public String getPartDesc() {
        return partDesc;
    }

    public void setPartDesc(String partDesc) {
        this.partDesc = partDesc;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }
}