package com.ellabook.entity.book;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 
 * 
 */
public class BorrowBookActivity implements Serializable {
    /**
     * 借书活动id
     */
    private Integer id;

    /**
     * 借书活动编码
     */
    private String activityCode;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动描述信息
     */
    private String activityInfo;

    /**
     * 借书活动类型：H5:H5送书活动，DIRECTIONAL:定向送书，CHANNEL:渠道送书，REGISTER注册送书
     */
    private String activityType;

    /**
     * 活动状态(WAITING：未开始,START：进行中,FINISHED:已结束,EXPIRED：已过期，STOP：禁用)
     */
    private String status;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 借书活动创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 借书活动开始时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 借书活动结束时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 是否限制数量 YES,NO
     */
    private String whetherLimit;

    /**
     * 活动参与人数上限
     */
    private Integer activityAmount;

    /**
     * 当前已参与活动的用户数量
     */
    private Integer joinAmount;

    /**
     * 送书数量
     */
    private Integer booksCount;

    /**
     * 送书组合
     */
    private String books;

    /**
     * 活动页面地址
     */
    private String activityAddress;

    /**
     * 修改时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 数据的可用状态（`NORMAL:正常 EXCEPTION:异常`）
     */
    private String activityStatus;

    /**
     * 点击量
     */
    private Integer clicks;

    private static final long serialVersionUID = 1L;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityInfo() {
        return activityInfo;
    }

    public void setActivityInfo(String activityInfo) {
        this.activityInfo = activityInfo;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getWhetherLimit() {
        return whetherLimit;
    }

    public void setWhetherLimit(String whetherLimit) {
        this.whetherLimit = whetherLimit;
    }

    public Integer getActivityAmount() {
        return activityAmount;
    }

    public void setActivityAmount(Integer activityAmount) {
        this.activityAmount = activityAmount;
    }

    public Integer getJoinAmount() {
        return joinAmount;
    }

    public void setJoinAmount(Integer joinAmount) {
        this.joinAmount = joinAmount;
    }

    public Integer getBooksCount() {
        return booksCount;
    }

    public void setBooksCount(Integer booksCount) {
        this.booksCount = booksCount;
    }

    public String getBooks() {
        return books;
    }

    public void setBooks(String books) {
        this.books = books;
    }

    public String getActivityAddress() {
        return activityAddress;
    }

    public void setActivityAddress(String activityAddress) {
        this.activityAddress = activityAddress;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Integer getClicks() {
        return clicks;
    }

    public void setClicks(Integer clicks) {
        this.clicks = clicks;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        BorrowBookActivity other = (BorrowBookActivity) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getActivityCode() == null ? other.getActivityCode() == null : this.getActivityCode().equals(other.getActivityCode()))
            && (this.getActivityName() == null ? other.getActivityName() == null : this.getActivityName().equals(other.getActivityName()))
            && (this.getActivityInfo() == null ? other.getActivityInfo() == null : this.getActivityInfo().equals(other.getActivityInfo()))
            && (this.getActivityType() == null ? other.getActivityType() == null : this.getActivityType().equals(other.getActivityType()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getChannelCode() == null ? other.getChannelCode() == null : this.getChannelCode().equals(other.getChannelCode()))
            && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()))
            && (this.getStartTime() == null ? other.getStartTime() == null : this.getStartTime().equals(other.getStartTime()))
            && (this.getEndTime() == null ? other.getEndTime() == null : this.getEndTime().equals(other.getEndTime()))
            && (this.getWhetherLimit() == null ? other.getWhetherLimit() == null : this.getWhetherLimit().equals(other.getWhetherLimit()))
            && (this.getActivityAmount() == null ? other.getActivityAmount() == null : this.getActivityAmount().equals(other.getActivityAmount()))
            && (this.getJoinAmount() == null ? other.getJoinAmount() == null : this.getJoinAmount().equals(other.getJoinAmount()))
            && (this.getBooksCount() == null ? other.getBooksCount() == null : this.getBooksCount().equals(other.getBooksCount()))
            && (this.getBooks() == null ? other.getBooks() == null : this.getBooks().equals(other.getBooks()))
            && (this.getActivityAddress() == null ? other.getActivityAddress() == null : this.getActivityAddress().equals(other.getActivityAddress()))
            && (this.getUpdateTime() == null ? other.getUpdateTime() == null : this.getUpdateTime().equals(other.getUpdateTime()))
            && (this.getActivityStatus() == null ? other.getActivityStatus() == null : this.getActivityStatus().equals(other.getActivityStatus()))
            && (this.getClicks() == null ? other.getClicks() == null : this.getClicks().equals(other.getClicks()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getActivityCode() == null) ? 0 : getActivityCode().hashCode());
        result = prime * result + ((getActivityName() == null) ? 0 : getActivityName().hashCode());
        result = prime * result + ((getActivityInfo() == null) ? 0 : getActivityInfo().hashCode());
        result = prime * result + ((getActivityType() == null) ? 0 : getActivityType().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getChannelCode() == null) ? 0 : getChannelCode().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        result = prime * result + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        result = prime * result + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        result = prime * result + ((getWhetherLimit() == null) ? 0 : getWhetherLimit().hashCode());
        result = prime * result + ((getActivityAmount() == null) ? 0 : getActivityAmount().hashCode());
        result = prime * result + ((getJoinAmount() == null) ? 0 : getJoinAmount().hashCode());
        result = prime * result + ((getBooksCount() == null) ? 0 : getBooksCount().hashCode());
        result = prime * result + ((getBooks() == null) ? 0 : getBooks().hashCode());
        result = prime * result + ((getActivityAddress() == null) ? 0 : getActivityAddress().hashCode());
        result = prime * result + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        result = prime * result + ((getActivityStatus() == null) ? 0 : getActivityStatus().hashCode());
        result = prime * result + ((getClicks() == null) ? 0 : getClicks().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", activityCode=").append(activityCode);
        sb.append(", activityName=").append(activityName);
        sb.append(", activityInfo=").append(activityInfo);
        sb.append(", activityType=").append(activityType);
        sb.append(", status=").append(status);
        sb.append(", channelCode=").append(channelCode);
        sb.append(", createTime=").append(createTime);
        sb.append(", startTime=").append(startTime);
        sb.append(", endTime=").append(endTime);
        sb.append(", whetherLimit=").append(whetherLimit);
        sb.append(", activityAmount=").append(activityAmount);
        sb.append(", joinAmount=").append(joinAmount);
        sb.append(", booksCount=").append(booksCount);
        sb.append(", books=").append(books);
        sb.append(", activityAddress=").append(activityAddress);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", activityStatus=").append(activityStatus);
        sb.append(", clicks=").append(clicks);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}