package com.ellabook.entity.analysis.vo;

import com.ellabook.entity.user.vo.PageVo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActiveVO {
    /*
     * 开始时间（yyyy-MM-dd）
     */
    private String startTime;
    /*
     * 结束时间（yyyy-MM-dd）//+1<
     */
    private String endTime;
    /*
     * 对比开始时间（yyyy-MM-dd）
     */
    private String compareStartTime;
    /*
     * 对比结束时间（yyyy-MM-dd）
     */
    private String compareEndTime;
    /*
     * 渠道列表
     */
    private List<String> channelList;
    /*
     * 版本列表
     */
    private List<String> versionList;
    /*
     * 分页参数
     */
    private PageVo pageVo;
    /*
     * 查询时间类型
     */
    private String timeType;
    /*
     * [对比开始时间，当前开始时间，当前结束时间]
     */
    private Date[] dates;
    /*
     *[对比开始时间，当前开始时间，当前结束时间]
     */
    private String[] days;
    /*
     * 是否需当前数据（未清洗）
     */
    private boolean qryCurrent;
    /*
     * 是否需对比
     */
    private boolean compare;
    /*
     * 当前时间
     */
    private Date now;
    /*
     * 分组模板
     */
    private String groupVal;
    /*
     * 2级分区key start
     */
    private Integer subColStart;
    /*
     * 2级分区key end
     */
    private Integer subColEnd;
    /*
     * 对比时间：2级分区key start
     */
    private Integer compSubColStart;
    /*
     * 对比时间：2级分区key end
     */
    private Integer compSubColEnd;

    public ActiveVO(String startTime, String endTime, String compareStartTime, String compareEndTime, List<String> channelList, List<String> versionList) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.compareStartTime = compareStartTime;
        this.compareEndTime = compareEndTime;
        this.channelList = channelList;
        this.versionList = versionList;
    }
}
