package com.ellabook.entity.analysis.vo;

import com.ellabook.entity.analysis.dto.BaseUserSynopsisDataDTO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class ActiveDataVO extends BaseUserSynopsisDataDTO {
    /*
     *  昨日活跃
     */
    @Getter
    private int dayCompareActiveUserNum;
    /*
     *  上周活跃
     */
    @Getter
    private int weekCompareActiveUserNum;
    /*
     * 上月活跃
     */
    @Getter
    private int monthCompareActiveUserNum;
    /*
     *  今日活跃
     */
    private int dayActiveUserNum;
    /*
     *  本周活跃
     */
    private int weekActiveUserNum;
    /*
     * 本月活跃
     */
    private int monthActiveUserNum;
    /**
     * 日活跃用户变化率
     */
    @Getter
    private double dayActiveUserChangingRate;
    /**
     * 周活跃用户变化率
     */
    @Getter
    private double weekActiveUserChangingRate;
    /**
     * 月活跃用户变化率
     */
    @Getter
    private double monthActiveUserChangingRate;
    /**
     * 昨日时间
     */
    @Getter
    private String dayCompareTime;
    /**
     * 上周时间
     */
    @Getter
    private String weekCompareTime;
    /**
     * 上月时间
     */
    @Getter
    private String monthCompareTime;

    public void compute() {
        dayActiveUserChangingRate = percent(dayActiveUserNum - dayCompareActiveUserNum, dayActiveUserNum);
        weekActiveUserChangingRate = percent(weekActiveUserNum - weekCompareActiveUserNum, weekActiveUserNum);
        monthActiveUserChangingRate = percent(monthActiveUserNum - monthCompareActiveUserNum, monthActiveUserNum);
    }
}