package com.ellabook.entity.analysis.dto;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

public class UserTrendsStartUserDetail implements Comparable<UserTrendsStartUserDetail> {
    private int startUserNum;
    private int startCounts;
    private long countAvgTime;
    private long userAvgTime;
    private long registerAvgTime;

    private String newUserRate;
    private String oldUserRate;
    private String analysisTime;

    private String androidRate;
    private String iosRate;
    private Map<String, String> channleRate;

    public String getAndroidRate() {
        return androidRate;
    }

    public void setAndroidRate(String androidRate) {
        this.androidRate = androidRate;
    }

    public String getIosRate() {
        return iosRate;
    }

    public void setIosRate(String iosRate) {
        this.iosRate = iosRate;
    }

    public Map<String, String> getChannleRate() {
        return channleRate;
    }

    public void setChannleRate(Map<String, String> channleRate) {
        this.channleRate = channleRate;
    }

    public String getAnalysisTime() {
        return analysisTime;
    }

    public void setAnalysisTime(String analysisTime) {
        this.analysisTime = analysisTime;
    }

    public int getStartCounts() {
        return startCounts;
    }

    public void setStartCounts(int startCounts) {
        this.startCounts = startCounts;
    }

    public long getCountAvgTime() {
        return countAvgTime;
    }

    public void setCountAvgTime(long countAvgTime) {
        this.countAvgTime = countAvgTime;
    }

    public long getUserAvgTime() {
        return userAvgTime;
    }

    public void setUserAvgTime(long userAvgTime) {
        this.userAvgTime = userAvgTime;
    }

    public long getRegisterAvgTime() {
        return registerAvgTime;
    }

    public void setRegisterAvgTime(long registerAvgTime) {
        this.registerAvgTime = registerAvgTime;
    }

    public String getNewUserRate() {
        return newUserRate;
    }

    public void setNewUserRate(String newUserRate) {
        this.newUserRate = newUserRate;
    }

    public String getOldUserRate() {
        return oldUserRate;
    }

    public void setOldUserRate(String oldUserRate) {
        this.oldUserRate = oldUserRate;
    }

    public int getStartUserNum() {
        return startUserNum;
    }

    public void setStartUserNum(int startUserNum) {
        this.startUserNum = startUserNum;
    }

    @Override
    public int compareTo(UserTrendsStartUserDetail o) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            long thisTime = sdf.parse(this.getAnalysisTime()).getTime();
            long compareTime = sdf.parse(o.getAnalysisTime()).getTime();
            return (int) -(thisTime - compareTime);
        } catch (ParseException e) {
        }
        return 0;
    }


}
