package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisPayDataDTO extends BaseUserSynopsisDataDTO {
    /*************付费用户************/
    /**
     * 付费用户数
     */
    @Getter
    private int totalPayUserNum;
    /**
     * 历史数据：对比付费用户数
     */
//    @Getter
    private int compareTotalPayUserNum;
//    /**
//     * 付费用户变化率
//     */
//    @Getter
//    private double payUserChangingRate;
    /**
     * 新增付费用户数
     */
    @Getter
    private int firstPayUserNum;
    /**
     * 新付费用户:占付费用户
     */
    @Getter
    private double firstPayUserRate;
    /**
     * 复购用户占比：占付费用户
     */
    @Getter
    private double boughtUserRate;
    /**
     * iOS付费用户
     */
    private int iosPayNum;
    /**
     * iOS付费占比：占付费用户
     */
    @Getter
    private double iosPayUserRate;
    /**
     * 安卓付费占比：占付费用户
     */
    @Getter
    private double androidPayUserRate;
    /**
     * 安卓各渠道用户占比：占付费用户
     */
    @Getter
    private List<ChannelDataVO> channelPayUserDataList = new ArrayList<>();
    /**
     * 充值咿啦币用户数//
     */
    private int totalRechargeUserNum;
    /**
     * 购买会员用户数//
     */
    private int totalMemberBuyUserNum;
    /**
     * 充值咿啦币占比：占付费用户
     */
    @Getter
    private double rechargeUserRate;
    /**
     * 购买会员占比：占付费用户
     */
    @Getter
    private double memberBuyUserRate;

    /**
     * 各商品用户占比：占付费用户
     */
//    @Getter private  double memberBuyUserRate;
    public void compute() {
        if (totalPayUserNum <= 0) {
            return;
        }
        firstPayUserNum = totalPayUserNum - compareTotalPayUserNum;
        //        第一次支付订单的用户数量（2次以上支付订单用户数量）/付费用户总数*100%
        firstPayUserRate = percent(firstPayUserNum, totalPayUserNum);
        boughtUserRate = leftPercentScale(totalPayUserNum, firstPayUserNum);
        iosPayUserRate = percent(iosPayNum, totalPayUserNum);
        androidPayUserRate = leftPercentScale(totalPayUserNum, iosPayNum);
//        充值咿啦币（会员商品）用户数/付费用户总数*100%
        rechargeUserRate = percent(totalRechargeUserNum, totalPayUserNum);
        memberBuyUserRate = percent(totalMemberBuyUserNum, totalPayUserNum);
    }

}
