package com.ellabook.entity.analysis.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 19:43
 * @Modified By:
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class KeyValDataDTO {
    private Object id;
    private String key;
    private BigDecimal value;
    private String msg;
    private Object data;
    private Double rate;

    public KeyValDataDTO(Object id, String key, int data, int value) {
        this.id = id;
        this.key = key;
        this.data = data;
        this.value = new BigDecimal(value);
    }

    public KeyValDataDTO(String key, String msg, int value) {
        this.key = key;
        this.msg = msg;
        this.value = new BigDecimal(value);
    }

    public String groupByMsg() {
        if (Objects.equals("h5", msg)) {
            return "H5";
        }
        return msg;
    }

    public String groupByDay() {
        return id.toString();
    }
}
