package com.ellabook.entity.analysis;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.codec.binary.Base64;

import java.io.IOException;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserBehaviorAnalysis {
    private String uid;

    private String ipAddress;

    private String operateType;

    private String operateContent;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date operateTime;

    public static int compareByUidThenOperateTime(UserBehaviorAnalysis l, UserBehaviorAnalysis r) {
        if (l.getUid().equals(r.getUid())) {
            return l.getOperateTime().compareTo(r.getOperateTime());
        } else {
            return l.getUid().compareTo(r.getUid());
        }
    }

    public void encodeBASE64() {
        if (getOperateContent() == null) {
            return;
        }
        String encodeBase64String = Base64.encodeBase64String(getOperateContent().getBytes());
        setOperateContent(encodeBase64String);
    }

    public void decodeBase64() throws IOException {
        if (getOperateContent() == null) {
            return;
        }
        byte[] bytes = Base64.decodeBase64(getOperateContent().getBytes());
        setOperateContent(new String(bytes));
    }
}